/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.persistence;

import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.bank.BankSystem;
import de.slashbinbash.hexen.bestiary.Bestiary;
import de.slashbinbash.hexen.bestiary.BestiarySystem;
import de.slashbinbash.hexen.chest.Chest;
import de.slashbinbash.hexen.chest.ChestSystem;
import de.slashbinbash.hexen.deadpool.DeadpoolSystem;
import de.slashbinbash.hexen.door.Door;
import de.slashbinbash.hexen.door.DoorSystem;
import de.slashbinbash.hexen.enums.Ability;
import de.slashbinbash.hexen.enums.Attribute;
import de.slashbinbash.hexen.guild.Guild;
import de.slashbinbash.hexen.guild.GuildSystem;
import de.slashbinbash.hexen.map.Location;
import de.slashbinbash.hexen.model.Abilities;
import de.slashbinbash.hexen.model.Attributes;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.model.CombatAction;
import de.slashbinbash.hexen.model.CombatActions;
import de.slashbinbash.hexen.model.Condition;
import de.slashbinbash.hexen.model.ConditionImmunities;
import de.slashbinbash.hexen.model.ConditionImmunity;
import de.slashbinbash.hexen.model.Damage;
import de.slashbinbash.hexen.model.DamageIntegers;
import de.slashbinbash.hexen.model.DamageReductions;
import de.slashbinbash.hexen.model.DamageResistances;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.model.Modifiers;
import de.slashbinbash.hexen.model.Party;
import de.slashbinbash.hexen.model.Slot;
import de.slashbinbash.hexen.model.Trait;
import de.slashbinbash.hexen.persistence.SaveState;
import de.slashbinbash.hexen.quest.Quest;
import de.slashbinbash.hexen.quest.QuestSystem;
import de.slashbinbash.hexen.shop.ShopSystem;
import de.slashbinbash.hexen.temple.TempleSystem;
import de.slashbinbash.hexen.workbench.RecipeSystem;
import de.slashbinbash.util.StaticXML;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Saver {
    private Document doc;

    public static SaveState createSaveGame(RPG rPG) {
        SaveState saveState = new SaveState();
        Location location = rPG.party.getLocation();
        Location location2 = new Location();
        location2.mapId = rPG.map.__id__;
        location2.level = location.level;
        location2.x = location.x;
        location2.y = location.y;
        saveState.location = location2;
        saveState.party = rPG.party;
        saveState.levelVisited = location.getLevel().visited;
        saveState.bankSystem = rPG.bankSystem;
        saveState.bestiarySystem = rPG.bestiarySystem;
        saveState.chestSystem = rPG.chestSystem;
        saveState.deadpoolSystem = rPG.deadpoolSystem;
        saveState.doorSystem = rPG.doorSystem;
        saveState.guildSystem = rPG.guildSystem;
        saveState.questSystem = rPG.questSystem;
        saveState.recipeSystem = rPG.recipeSystem;
        saveState.shopSystem = rPG.shopSystem;
        saveState.templeSystem = rPG.templeSystem;
        saveState.timeSeconds = rPG.timeSeconds;
        saveState.stateMap = rPG.stateMap;
        return saveState;
    }

    public static void saveXML(File file, SaveState saveState) {
        Saver saver = new Saver();
        saver.save(file, saveState);
    }

    public static String writeBinaryData(boolean[][] blArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < blArray.length; ++i) {
            for (int j = 0; j < blArray[i].length; ++j) {
                stringBuilder.append(blArray[i][j] ? "1" : "0");
            }
        }
        return stringBuilder.toString();
    }

    private Element createAbilities(Abilities abilities) {
        if (abilities == null) {
            return null;
        }
        Element element = this.doc.createElement("abilities");
        for (Map.Entry<Ability, Integer> entry : abilities.entrySet()) {
            Element element2 = this.doc.createElement("ability");
            element2.setAttribute("name", entry.getKey().id);
            element2.setAttribute("value", String.valueOf(entry.getValue()));
            element.appendChild(element2);
        }
        return element;
    }

    private Element createAttributes(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        Element element = this.doc.createElement("attributes");
        for (Map.Entry<Attribute, Integer> entry : attributes.entrySet()) {
            Element element2 = this.doc.createElement("attribute");
            element2.setAttribute("name", entry.getKey().id);
            element2.setAttribute("value", String.valueOf(entry.getValue()));
            element.appendChild(element2);
        }
        return element;
    }

    private Element createBankSystem(BankSystem bankSystem) {
        if (bankSystem == null || bankSystem.currency == 0) {
            return null;
        }
        Element element = this.doc.createElement("bank");
        Element element2 = this.doc.createElement("account");
        element2.setAttribute("balance", String.valueOf(bankSystem.currency));
        element.appendChild(element2);
        return element;
    }

    private Element createBestiarySystem(BestiarySystem bestiarySystem) {
        if (bestiarySystem == null || bestiarySystem.map.isEmpty()) {
            return null;
        }
        Element element = this.doc.createElement("bestiary");
        for (Map.Entry<String, Bestiary.State> entry : bestiarySystem.map.entrySet()) {
            Bestiary.State state = entry.getValue();
            if (state == null) continue;
            Element element2 = this.doc.createElement("entry");
            element2.setAttribute("id", state.creatureId);
            element2.setAttribute("name", state.creatureName);
            element2.setAttribute("defeated", String.valueOf(state.recorded));
            element2.setAttribute("reported", String.valueOf(state.reported));
            element.appendChild(element2);
        }
        return element;
    }

    private Element createChestSystem(ChestSystem chestSystem) {
        if (chestSystem == null || chestSystem.states.isEmpty()) {
            return null;
        }
        Element element = this.doc.createElement("chests");
        for (Map.Entry<String, Chest.State> entry : chestSystem.states.entrySet()) {
            Element element2 = this.doc.createElement("chest");
            element2.setAttribute("id", entry.getKey());
            element2.setAttribute("empty", String.valueOf(entry.getValue().empty));
            element.appendChild(element2);
        }
        return element;
    }

    private Element createCombatActions(CombatActions combatActions) {
        if (combatActions == null) {
            return null;
        }
        Element element = this.doc.createElement("combatActions");
        for (CombatAction combatAction : combatActions) {
            Element element2 = this.doc.createElement("combatAction");
            element2.setAttribute("ref", combatAction.getId());
            element.appendChild(element2);
        }
        return element;
    }

    private Element createCondition(Condition condition) {
        Element element = this.doc.createElement("condition");
        element.setAttribute("ref", condition.getId());
        Element element2 = StaticXML.createTextElement(this.doc, "timeLeftSeconds", condition.timeLeftSeconds);
        element.appendChild(element2);
        return element;
    }

    /*
     * WARNING - void declaration
     */
    private Element createCreature(ClassCreature classCreature) {
        Element element;
        Element element2;
        Element element3;
        Element element4 = this.doc.createElement("creature");
        if (classCreature.__id__ != null) {
            element3 = StaticXML.createTextElement(this.doc, "id", classCreature.__id__);
            element4.appendChild(element3);
        }
        element3 = StaticXML.createTextElement(this.doc, "name", classCreature.name);
        element4.appendChild(element3);
        Element element5 = StaticXML.createTextElement(this.doc, "portrait", classCreature.portrait);
        if (element5 != null) {
            element4.appendChild(element5);
        }
        Element element6 = StaticXML.createTextElement(this.doc, "playable", classCreature.playable);
        element4.appendChild(element6);
        Element element7 = StaticXML.createTextElement(this.doc, "hp", classCreature.hitPoints);
        element4.appendChild(element7);
        Element element8 = StaticXML.createTextElement(this.doc, "ap", classCreature.actionPoints);
        element4.appendChild(element8);
        Element element9 = StaticXML.createTextElement(this.doc, "maxhp", classCreature.maxHitPoints);
        element4.appendChild(element9);
        Element element10 = StaticXML.createTextElement(this.doc, "maxap", classCreature.maxActionPoints);
        element4.appendChild(element10);
        Element element11 = StaticXML.createTextElement(this.doc, "vim", classCreature.vim);
        element4.appendChild(element11);
        Element element12 = StaticXML.createTextElement(this.doc, "timeStarted", classCreature.timeStarted);
        element4.appendChild(element12);
        Element element13 = StaticXML.createTextElement(this.doc, "numCombats", classCreature.numCombats);
        element4.appendChild(element13);
        Element element14 = StaticXML.createTextElement(this.doc, "numRevives", classCreature.numRevives);
        element4.appendChild(element14);
        Element element15 = StaticXML.createTextElement(this.doc, "job", classCreature.job);
        if (element15 != null) {
            element4.appendChild(element15);
        }
        Element element16 = this.createCombatActions(classCreature.combatActions);
        element4.appendChild(element16);
        Element element17 = this.createModifiers(classCreature.modifiers);
        element4.appendChild(element17);
        if (classCreature.hasTraits()) {
            element2 = this.doc.createElement("traits");
            for (Trait object : Trait.values()) {
                if (!classCreature.hasTrait(object)) continue;
                element = this.doc.createElement("trait");
                element.setAttribute("ref", object.id);
                element2.appendChild(element);
            }
            element4.appendChild(element2);
        }
        if (classCreature.equipment != null) {
            element2 = this.doc.createElement("equipment");
            element2.setAttribute("ref", classCreature.equipment.getId());
            element4.appendChild(element2);
        }
        if (classCreature.getConditions() != null && !classCreature.getConditions().isEmpty()) {
            element2 = this.doc.createElement("conditions");
            for (Condition condition : classCreature.getConditions()) {
                element2.appendChild(this.createCondition(condition));
            }
            element4.appendChild(element2);
        }
        if (classCreature.mods != null) {
            void var19_23;
            element2 = this.doc.createElement("mods");
            element2.setAttribute("slots", classCreature.mods.getId());
            Iterator<Object> iterator = classCreature.mods.values();
            boolean bl = false;
            while (var19_23 < ((Iterator<Object>)iterator).length) {
                if (((Slot)((Object)iterator[var19_23])).mod != null) {
                    element = this.doc.createElement("slot");
                    element.setAttribute("id", String.valueOf((int)var19_23));
                    element.setAttribute("ref", ((Slot)((Object)iterator[var19_23])).mod.getId());
                    element2.appendChild(element);
                }
                ++var19_23;
            }
            element4.appendChild(element2);
        }
        return element4;
    }

    private Element createDamageAttack(DamageIntegers damageIntegers) {
        assert (false);
        return null;
    }

    private Element createDamageReductions(DamageReductions damageReductions) {
        if (damageReductions == null || damageReductions.isEmpty()) {
            return null;
        }
        Element element = this.doc.createElement("damageReductions");
        for (Map.Entry entry : damageReductions.entrySet()) {
            Damage damage = (Damage)entry.getKey();
            int n = (Integer)entry.getValue();
            Element element2 = this.doc.createElement("damageValue");
            element2.setAttribute("component", damage.component.name());
            element2.setAttribute("type", damage.type.name);
            element2.setAttribute("value", String.valueOf(n));
            element.appendChild(element2);
        }
        return element;
    }

    private Element createDamageResistances(DamageResistances damageResistances) {
        if (damageResistances == null || damageResistances.isEmpty()) {
            return null;
        }
        Element element = this.doc.createElement("damageResistances");
        for (Map.Entry entry : damageResistances.entrySet()) {
            Damage damage = (Damage)entry.getKey();
            float f = ((Float)entry.getValue()).floatValue();
            Element element2 = this.doc.createElement("damageRatio");
            element2.setAttribute("component", damage.component.name());
            element2.setAttribute("type", damage.type.name);
            element2.setAttribute("value", String.valueOf(f));
            element.appendChild(element2);
        }
        return element;
    }

    private Element createDeadpoolSystem(DeadpoolSystem deadpoolSystem) {
        if (deadpoolSystem == null || deadpoolSystem.isEmpty()) {
            return null;
        }
        Element element = this.doc.createElement("deadpool");
        element.setAttribute("lost", String.valueOf(deadpoolSystem.lostSouls));
        DeadpoolSystem.Entry entry = deadpoolSystem.entry;
        Element element2 = this.doc.createElement("location");
        element2.setAttribute("map", entry.location.map);
        element2.setAttribute("level", String.valueOf(entry.location.level));
        element2.setAttribute("x", String.valueOf(entry.location.x));
        element2.setAttribute("y", String.valueOf(entry.location.y));
        element.appendChild(element2);
        element2 = this.createParty(entry.party);
        element.appendChild(element2);
        return element;
    }

    private Element createDoorSystem(DoorSystem doorSystem) {
        if (doorSystem == null || doorSystem.states.isEmpty()) {
            return null;
        }
        Element element = this.doc.createElement("doors");
        for (Map.Entry<String, Door.State> entry : doorSystem.states.entrySet()) {
            Element element2 = this.doc.createElement("door");
            element2.setAttribute("id", entry.getKey());
            element2.setAttribute("lock_unlocked", String.valueOf(entry.getValue().lock_unlocked));
            element.appendChild(element2);
        }
        return element;
    }

    private Element createGuildSystem(GuildSystem guildSystem) {
        if (guildSystem == null || guildSystem.entrySet().isEmpty()) {
            return null;
        }
        Element element = this.doc.createElement("guilds");
        for (Map.Entry<String, Guild.State> entry : guildSystem.entrySet()) {
            String string = entry.getKey();
            Guild.State state = entry.getValue();
            if (state.entries.isEmpty()) continue;
            Element element2 = this.doc.createElement("guild");
            element.appendChild(element2);
            element2.setAttribute("id", string);
            Element element3 = this.doc.createElement("creatures");
            element2.appendChild(element3);
            for (ClassCreature classCreature : state.entries) {
                Element element4 = this.createCreature(classCreature);
                element3.appendChild(element4);
            }
        }
        return element.hasChildNodes() ? element : null;
    }

    private Element createImmunities(ConditionImmunities conditionImmunities) {
        if (conditionImmunities == null || conditionImmunities.isEmpty()) {
            return null;
        }
        Element element = this.doc.createElement("immunities");
        for (ConditionImmunity conditionImmunity : conditionImmunities) {
            Element element2 = this.doc.createElement("immunity");
            element2.setAttribute("ref", conditionImmunity.conditionId);
            element.appendChild(element2);
        }
        return element;
    }

    private Element createItemStack(Item item) {
        Element element = this.doc.createElement("item");
        element.setAttribute("ref", item.getId());
        element.setAttribute("amount", String.valueOf(item.count));
        return element;
    }

    private Element createLevelVisited(boolean[][] blArray) {
        Element element = this.doc.createElement("levelVisited");
        element.setAttribute("width", String.valueOf(blArray.length));
        element.setAttribute("height", String.valueOf(blArray[0].length));
        element.setTextContent(Saver.writeBinaryData(blArray));
        return element;
    }

    private Element createModifiers(Modifiers modifiers) {
        Element element;
        if (modifiers == null) {
            return null;
        }
        Element element2 = this.doc.createElement("modifiers");
        Element element3 = StaticXML.createTextElement(this.doc, "critChance", modifiers.modCritChance);
        element2.appendChild(element3);
        Element element4 = StaticXML.createTextElement(this.doc, "hitChanceAttacker", modifiers.modHitChanceAttacker);
        element2.appendChild(element4);
        Element element5 = StaticXML.createTextElement(this.doc, "hitChanceDefender", modifiers.modHitChanceDefender);
        element2.appendChild(element5);
        Element element6 = StaticXML.createTextElement(this.doc, "immuneToCrits", modifiers.modImmuneToCrits);
        element2.appendChild(element6);
        if (modifiers.modAbilities != null) {
            element = this.createAbilities(modifiers.modAbilities);
            element2.appendChild(element);
        }
        if (modifiers.modAttributes != null) {
            element = this.createAttributes(modifiers.modAttributes);
            element2.appendChild(element);
        }
        if (modifiers.modDamageAttack != null) {
            element = this.createDamageAttack(modifiers.modDamageAttack);
            element2.appendChild(element);
        }
        if (modifiers.modDamageReductions != null) {
            element = this.createDamageReductions(modifiers.modDamageReductions);
            element2.appendChild(element);
        }
        if (modifiers.modDamageResistances != null) {
            element = this.createDamageResistances(modifiers.modDamageResistances);
            element2.appendChild(element);
        }
        if (modifiers.modImmunities != null) {
            element = this.createImmunities(modifiers.modImmunities);
            element2.appendChild(element);
        }
        return element2;
    }

    private Element createParty(Party party) {
        Element element = this.doc.createElement("party");
        Element element2 = this.doc.createElement("creatures");
        for (ClassCreature object : party.getMembers()) {
            element2.appendChild(this.createCreature(object));
        }
        element.appendChild(element2);
        Element element3 = this.doc.createElement("inventory");
        for (Item item : party.inventory) {
            element3.appendChild(this.createItemStack(item));
        }
        element.appendChild(element3);
        if (party.guild != null) {
            Element element4 = this.doc.createElement("guild");
            element4.setAttribute("id", party.guild);
            element.appendChild(element4);
        }
        return element;
    }

    private Element createQuestSystem(QuestSystem questSystem) {
        if (questSystem == null || questSystem.entrySet().isEmpty()) {
            return null;
        }
        Element element = this.doc.createElement("quests");
        for (Map.Entry<String, Quest.State> entry : questSystem.entrySet()) {
            String string = entry.getKey();
            Quest.State state = entry.getValue();
            Element element2 = this.doc.createElement("quest");
            element2.setAttribute("ref", string);
            element2.setAttribute("state", state.state.name());
            element2.setAttribute("started", String.valueOf(state.started));
            element.appendChild(element2);
        }
        return element;
    }

    private Element createRecipeSystem(RecipeSystem recipeSystem) {
        if (recipeSystem == null || recipeSystem.recipes.isEmpty()) {
            return null;
        }
        Element element = this.doc.createElement("recipes");
        for (String string : recipeSystem.recipes) {
            Element element2 = this.doc.createElement("recipe");
            element2.setAttribute("ref", string);
            element.appendChild(element2);
        }
        return element;
    }

    private Element createShopSystem(ShopSystem shopSystem) {
        if (shopSystem == null || shopSystem.identifiedItems.isEmpty()) {
            return null;
        }
        Element element = this.doc.createElement("shops");
        if (!shopSystem.identifiedItems.isEmpty()) {
            Element element2 = this.doc.createElement("identified");
            for (String string : shopSystem.identifiedItems) {
                Element element3 = this.doc.createElement("item");
                element3.setAttribute("ref", string);
                element2.appendChild(element3);
            }
            element.appendChild(element2);
        }
        return element;
    }

    private Element createTempleSystem(TempleSystem templeSystem) {
        if (templeSystem == null) {
            return null;
        }
        Element element = this.doc.createElement("temples");
        if (!templeSystem.donations.isEmpty()) {
            Element element2 = this.doc.createElement("donations");
            for (Map.Entry<String, Integer> entry : templeSystem.donations.entrySet()) {
                Element element3 = this.doc.createElement("donation");
                element3.setAttribute("id", entry.getKey());
                element3.setAttribute("value", String.valueOf(entry.getValue()));
                element2.appendChild(element3);
            }
            element.appendChild(element2);
        }
        return element;
    }

    public void save(File file, SaveState saveState) {
        Element element;
        Element element2;
        Element element3;
        Element element4;
        Element element5;
        Element element6;
        Element element7;
        Element element8;
        Element element9;
        this.doc = StaticXML.createDocument();
        Element element10 = this.doc.createElement("savestate");
        element10.setAttribute("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        Element element11 = StaticXML.createTextElement(this.doc, "timeSeconds", saveState.timeSeconds);
        element10.appendChild(element11);
        Element element12 = this.doc.createElement("location");
        element12.setAttribute("mapId", saveState.location.mapId);
        element12.setAttribute("level", String.valueOf(saveState.location.level));
        element12.setAttribute("x", String.valueOf(saveState.location.x));
        element12.setAttribute("y", String.valueOf(saveState.location.y));
        element10.appendChild(element12);
        Element element13 = this.createLevelVisited(saveState.levelVisited);
        element10.appendChild(element13);
        this.doc.appendChild(element10);
        element10.appendChild(this.createParty(saveState.party));
        Element element14 = this.createBankSystem(saveState.bankSystem);
        if (element14 != null) {
            element10.appendChild(element14);
        }
        if ((element9 = this.createBestiarySystem(saveState.bestiarySystem)) != null) {
            element10.appendChild(element9);
        }
        if ((element8 = this.createChestSystem(saveState.chestSystem)) != null) {
            element10.appendChild(element8);
        }
        if ((element7 = this.createDeadpoolSystem(saveState.deadpoolSystem)) != null) {
            element10.appendChild(element7);
        }
        if ((element6 = this.createDoorSystem(saveState.doorSystem)) != null) {
            element10.appendChild(element6);
        }
        if ((element5 = this.createGuildSystem(saveState.guildSystem)) != null) {
            element10.appendChild(element5);
        }
        if ((element4 = this.createQuestSystem(saveState.questSystem)) != null) {
            element10.appendChild(element4);
        }
        if ((element3 = this.createRecipeSystem(saveState.recipeSystem)) != null) {
            element10.appendChild(element3);
        }
        if ((element2 = this.createShopSystem(saveState.shopSystem)) != null) {
            element10.appendChild(element2);
        }
        if ((element = this.createTempleSystem(saveState.templeSystem)) != null) {
            element10.appendChild(element);
        }
        if (saveState.stateMap != null && !saveState.stateMap.isEmpty()) {
            Element element15 = this.doc.createElement("states");
            for (Map.Entry<String, Object> entry : saveState.stateMap.entrySet()) {
                Element element16 = this.doc.createElement("state");
                element16.setAttribute("key", entry.getKey());
                if (entry.getValue() != null) {
                    element16.setAttribute("value", entry.getValue().toString());
                }
                element15.appendChild(element16);
            }
            element10.appendChild(element15);
        }
        StaticXML.saveXML(this.doc, file);
    }
}

