/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.quest;

import de.slashbinbash.hexen.factory.AttributeFactory;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.quest.Quest;
import de.slashbinbash.util.StaticXML;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class QuestFactory {
    public static Quest createQuest(String string) {
        File file = new File(Factory.QUEST_PATH + string + ".xml");
        try {
            Document document = StaticXML.loadXML(file);
            Quest.Data data = QuestFactory.createQuestData(document.getDocumentElement());
            data.__id__ = string;
            Quest quest = new Quest();
            quest._data = data;
            return quest;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    private static Quest.Data createQuestData(Element element) {
        Quest.Data data = new Quest.Data();
        block10: for (Element element2 : StaticXML.getChildElements(element)) {
            switch (element2.getTagName()) {
                case "name": {
                    data.name = StaticXML.getText(element2);
                    continue block10;
                }
                case "description": {
                    data.description = Factory.unformatMD(StaticXML.getText(element2));
                    continue block10;
                }
                case "attributes": {
                    data.attributes = AttributeFactory.createAttributes(element2);
                    continue block10;
                }
            }
            StaticXML.errUnknownTag(element2);
        }
        return data;
    }
}

