/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.renderer;

import de.slashbinbash.hexen.ui.Button;
import de.slashbinbash.opengl.Color;
import de.slashbinbash.opengl.math.Rect2f;
import de.slashbinbash.opengl.renderer.Draw2D;
import java.util.List;

public class ButtonRenderer {
    public static final boolean DEBUG = false;

    public static void drawButton(Draw2D draw2D, Button button, Style style) {
        switch (style.ordinal()) {
            case 0: {
                draw2D.setColor(Color.WHITE);
                draw2D.drawString(button.rect.x, button.rect.y + button.rect.height * 0.5f - 4.0f, button.label);
                break;
            }
            case 1: {
                draw2D.setColor(Color.WHITE);
                draw2D.fillRect(button.rect.x, button.rect.y, button.rect.width, button.rect.height);
                draw2D.setColor(Color.BLACK);
                draw2D.drawString(button.rect.x, button.rect.y + button.rect.height * 0.5f - 4.0f, button.label);
                break;
            }
            case 2: {
                if (button.selected) {
                    if (button.colorSelected != null) {
                        draw2D.setColor(button.colorSelected);
                        draw2D.fillRect(button.rect.x, button.rect.y, button.rect.width, button.rect.height);
                    }
                } else if (button.colorBackground != null) {
                    draw2D.setColor(button.colorBackground);
                    draw2D.fillRect(button.rect.x, button.rect.y, button.rect.width, button.rect.height);
                }
                draw2D.setColor(Color.WHITE);
                draw2D.drawTexture(button.tex, button.tx, button.ty, button.twidth, button.theight, button.rect.x, button.rect.y, button.rect.width, button.rect.height);
                break;
            }
        }
    }

    public static void drawButtons(Draw2D draw2D, List<Button> list, Style style) {
        for (Button button : list) {
            ButtonRenderer.drawButton(draw2D, button, style);
        }
    }

    public static void drawSelectionArrow(Draw2D draw2D, Button button) {
        Rect2f rect2f = button.rect;
        draw2D.setColor(Color.WHITE);
        draw2D.drawString(rect2f.x - 8.0f, button.rect.y + button.rect.height * 0.5f - 4.0f, ">");
    }

    public static void drawSelectionHighlight(Draw2D draw2D, Button button) {
        Rect2f rect2f = button.rect;
        draw2D.setColor(Color.DARK_GREY);
        draw2D.fillRect(rect2f.x, rect2f.y, rect2f.width, rect2f.height);
    }

    public static void drawSelectionHighlight(Draw2D draw2D, float f, float f2, float f3, float f4) {
        draw2D.setColor(Color.DARK_GREY);
        draw2D.fillRect(f, f2, f3, f4);
    }

    public static void drawOptions(Draw2D draw2D, List<Button> list) {
        for (Button button : list) {
            if (!button.selected) continue;
            draw2D.setColor(Color.DARK_GREY);
            draw2D.fillRect(button.rect.left(), button.rect.top(), button.rect.width, button.rect.height);
        }
        for (Button button : list) {
            float[] fArray = button.selected ? Color.WHITE : button.colorBackground;
            if (fArray == null) continue;
            draw2D.setColor(fArray);
            draw2D.fillRect(button.rect.x, button.rect.y, 16.0f, 16.0f);
        }
        draw2D.setColor(Color.WHITE);
        draw2D.begin();
        for (Button button : list) {
            if (button.tex == null) continue;
            draw2D.drawTexture(button.tex, button.tx, button.ty, button.twidth, button.theight, button.rect.x, button.rect.y, 16.0f, 16.0f);
        }
        draw2D.end();
        draw2D.setColor(Color.WHITE);
        draw2D.begin();
        for (Button button : list) {
            if (button.label == null) {
                System.out.println("FNARD");
            }
            draw2D.drawString(button.rect.left() + 24.0f, button.rect.top() + 4.0f, button.label);
        }
        draw2D.end();
    }

    public static enum Style {
        Item,
        Button,
        Image,
        ButtonImage;

    }
}

