/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.renderer;

import de.slashbinbash.opengl.GLByteBuffer;
import de.slashbinbash.opengl.Shader;
import de.slashbinbash.opengl.ShaderFactory;
import de.slashbinbash.opengl.Texture;
import de.slashbinbash.util.Resource;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class GLDraw3D {
    private static final int NUM_FLOATS_PRIM = 7;
    private static final int NUM_FLOATS_TEX = 9;
    private static final int DRAW_POINT = 1;
    public static final int DRAW_LINE = 2;
    public static final int DRAW_TEXTURE = 3;
    public static final int BLEND = 1;
    public static final int DEPTH = 2;
    private float[] color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    public Texture tex = null;
    private GLByteBuffer bb = null;
    private int bufferSize;
    private int vbo = 0;
    private int primVao = 0;
    private Shader primShader = null;
    private int texVao = 0;
    private Shader texShader = null;
    private Matrix4f projectionMatrix = new Matrix4f();
    private Matrix4f modelViewMatrix = new Matrix4f();
    private Matrix4f[] matrixStack = new Matrix4f[25];
    private int matrixStackPtr = -1;
    private Vector3f v = new Vector3f();
    private int fbo = -1;
    private boolean fboBound = false;
    private boolean buffering = false;
    private int bufferType = 0;

    public GLDraw3D(GLByteBuffer gLByteBuffer) {
        this.bb = gLByteBuffer;
        try {
            this.primShader = ShaderFactory.createShader(new Resource("shader/VVVCCCC.vert").readString(), new Resource("shader/VVVCCCC.frag").readString());
            this.texShader = ShaderFactory.createShader(new Resource("shader/VVVCCCCTT.vert").readString(), new Resource("shader/VVVCCCCTT.frag").readString());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.vbo = GL15.glGenBuffers();
        this.primVao = GL30.glGenVertexArrays();
        GL30.glBindVertexArray((int)this.primVao);
        GL15.glBindBuffer((int)34962, (int)this.vbo);
        int n = 28;
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)n, (long)0L);
        GL20.glVertexAttribPointer((int)1, (int)4, (int)5126, (boolean)false, (int)n, (long)12L);
        GL15.glBindBuffer((int)34962, (int)0);
        GL30.glBindVertexArray((int)0);
        this.texVao = GL30.glGenVertexArrays();
        GL30.glBindVertexArray((int)this.texVao);
        GL15.glBindBuffer((int)34962, (int)this.vbo);
        n = 36;
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)n, (long)0L);
        GL20.glVertexAttribPointer((int)1, (int)4, (int)5126, (boolean)false, (int)n, (long)12L);
        GL20.glVertexAttribPointer((int)2, (int)2, (int)5126, (boolean)false, (int)n, (long)28L);
        GL15.glBindBuffer((int)34962, (int)0);
        GL30.glBindVertexArray((int)0);
    }

    public void begin(int n) {
        if (!this.buffering) {
            this.buffering = true;
            this.bufferType = n;
            this.bb.clear();
        }
    }

    public void begin() {
        if (!this.buffering) {
            this.buffering = true;
            this.bb.clear();
        }
    }

    public void bufferBytes(GLByteBuffer gLByteBuffer, int n) {
        assert (this.buffering);
        this.bb.put(gLByteBuffer);
        this.bufferType = n;
    }

    public void bufferTex(float f, float f2, float f3, float f4, float f5) {
        this.bb.vertex3f(f, f2, f3);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
        this.bb.texcoord2f(f4, f5);
    }

    private void bufferLine(float f, float f2, float f3, float f4, float f5, float f6) {
        this.bb.vertex3f(f, f2, f3);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
        this.bb.vertex3f(f4, f5, f6);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
    }

    private void bufferPoint(float f, float f2, float f3) {
        this.bb.vertex3f(f, f2, f3);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
    }

    public void checkCapacity(int n) {
        this.bb.capacity(n);
    }

    public void clear() {
        GL11.glClear((int)16640);
    }

    public void disable(int n) {
        switch (n) {
            case 1: {
                GL11.glDisable((int)3042);
                break;
            }
            case 2: {
                GL11.glDisable((int)2929);
            }
        }
    }

    public void drawLine(float f, float f2, float f3, float f4, float f5, float f6) {
        this.bufferType = 2;
        if (this.buffering) {
            this.bufferLine(f, f2, f3, f4, f5, f6);
        } else {
            this.begin();
            this.bufferLine(f, f2, f3, f4, f5, f6);
            this.end();
        }
    }

    public void drawPoint(float f, float f2, float f3) {
        this.bufferType = 1;
        if (this.buffering) {
            this.bufferPoint(f, f2, f3);
        } else {
            this.begin();
            this.bufferPoint(f, f2, f3);
            this.end();
        }
    }

    private void drawPrim(int n) {
        this.drawPrim(n, 0, this.bufferSize / 4 / 7);
    }

    private void drawPrim(int n, int n2, int n3) {
        this.primShader.enable();
        this.primShader.setUniformMatrix4f("ProjectionMatrix", this.projectionMatrix);
        this.primShader.setUniformMatrix4f("ModelViewMatrix", this.modelViewMatrix);
        GL30.glBindVertexArray((int)this.primVao);
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL11.glDrawArrays((int)n, (int)n2, (int)n3);
        GL20.glDisableVertexAttribArray((int)1);
        GL20.glDisableVertexAttribArray((int)0);
        GL30.glBindVertexArray((int)0);
        this.primShader.disable();
    }

    private void drawTex(int n, int n2) {
        this.drawTex(n, n2, 0, this.bufferSize / 4 / 9);
    }

    private void drawTex(int n, int n2, int n3, int n4) {
        this.texShader.enable();
        this.texShader.setUniformMatrix4f("ProjectionMatrix", this.projectionMatrix);
        this.texShader.setUniformMatrix4f("ModelViewMatrix", this.modelViewMatrix);
        GL11.glBindTexture((int)3553, (int)n);
        GL13.glActiveTexture((int)33984);
        GL30.glBindVertexArray((int)this.texVao);
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glEnableVertexAttribArray((int)2);
        GL11.glDrawArrays((int)n2, (int)n3, (int)n4);
        GL20.glDisableVertexAttribArray((int)2);
        GL20.glDisableVertexAttribArray((int)1);
        GL20.glDisableVertexAttribArray((int)0);
        GL30.glBindVertexArray((int)0);
        GL11.glBindTexture((int)3553, (int)0);
        this.texShader.disable();
    }

    public void enable(int n) {
        switch (n) {
            case 1: {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                break;
            }
            case 2: {
                GL11.glEnable((int)2929);
            }
        }
    }

    public void end() {
        assert (this.buffering);
        this.bb.flip();
        this.bufferSize = this.bb.limit();
        GL15.glBindBuffer((int)34962, (int)this.vbo);
        GL15.glBufferData((int)34962, (ByteBuffer)this.bb.data(), (int)35048);
        GL15.glBindBuffer((int)34962, (int)0);
        switch (this.bufferType) {
            case 1: {
                this.drawPrim(0);
                break;
            }
            case 2: {
                this.drawPrim(1);
                break;
            }
            case 3: {
                GL11.glEnable((int)3553);
                if (this.tex.format == 6408) {
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    this.drawTex(this.tex.id, 4);
                    GL11.glDisable((int)3042);
                } else {
                    this.drawTex(this.tex.id, 4);
                }
                GL11.glDisable((int)3553);
            }
        }
        this.bufferType = 0;
        this.buffering = false;
    }

    public void loadIdentity() {
        this.modelViewMatrix.identity();
    }

    public void loadModelViewMatrix(Matrix4f matrix4f) {
        this.modelViewMatrix.set(matrix4f);
    }

    public void loadProjectionMatrix(Matrix4f matrix4f) {
        this.projectionMatrix.set(matrix4f);
    }

    public void mulModelViewMatrix(Matrix4f matrix4f) {
        this.modelViewMatrix.mul(matrix4f);
    }

    public void popMatrix() {
        this.modelViewMatrix.set(this.matrixStack[this.matrixStackPtr]);
        --this.matrixStackPtr;
    }

    public void pushMatrix() {
        ++this.matrixStackPtr;
        if (this.matrixStack[this.matrixStackPtr] == null) {
            this.matrixStack[this.matrixStackPtr] = new Matrix4f(this.modelViewMatrix);
        } else {
            this.matrixStack[this.matrixStackPtr].set(this.modelViewMatrix);
        }
    }

    public void rotatef(float f, float f2, float f3, float f4) {
        this.v.x = f2;
        this.v.y = f3;
        this.v.z = f4;
        this.modelViewMatrix.rotate(f, this.v);
    }

    public void scalef(float f, float f2, float f3) {
        this.v.x = f;
        this.v.y = f2;
        this.v.z = f3;
        this.modelViewMatrix.scale(this.v);
    }

    public void setColor(float f, float f2, float f3, float f4) {
        this.color[0] = f;
        this.color[1] = f2;
        this.color[2] = f3;
        this.color[3] = f4;
    }

    public void setColor(float[] fArray) {
        this.color[0] = fArray[0];
        this.color[1] = fArray[1];
        this.color[2] = fArray[2];
        this.color[3] = fArray[3];
    }

    public void setViewport(int n, int n2, int n3, int n4) {
        GL11.glViewport((int)n, (int)n2, (int)n3, (int)n4);
    }

    public void storeModelViewMatrix(Matrix4f matrix4f) {
        matrix4f.set(this.modelViewMatrix);
    }

    public void storeProjectionMatrix(Matrix4f matrix4f) {
        matrix4f.set(this.projectionMatrix);
    }

    public void translatef(float f, float f2, float f3) {
        this.v.x = f;
        this.v.y = f2;
        this.v.z = f3;
        this.modelViewMatrix.translate(this.v);
    }

    public void setRenderTarget(Texture texture) {
        if (texture == null) {
            GL30.glBindFramebuffer((int)36160, (int)0);
            this.fboBound = false;
        } else {
            if (this.fbo == -1) {
                this.fbo = GL30.glGenFramebuffers();
            }
            if (!this.fboBound) {
                GL30.glBindFramebuffer((int)36160, (int)this.fbo);
                this.fboBound = true;
            }
            GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)texture.id, (int)0);
        }
    }
}

