/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.renderer;

import de.slashbinbash.hexen.enums.Direction;
import de.slashbinbash.hexen.map.Level;
import de.slashbinbash.hexen.map.Tile;
import de.slashbinbash.hexen.map.TileEdge;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class LevelRenderer {
    private static final int SIZE = 32;
    private static final int SIZE3 = 10;
    private static final Stroke thindashed = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{3.0f}, 0.0f);
    public Color bgColor = Color.BLACK;
    public Color floorColor = Color.BLUE.darker();
    public Color wallColor = Color.CYAN;
    public Color encounterColor = Color.WHITE;

    private void drawDoor(Graphics2D graphics2D, int n, int n2, Direction direction) {
        int n3 = n;
        int n4 = n + 10 - 1;
        int n5 = n + 32 - 10;
        int n6 = n + 32 - 1;
        int n7 = n2;
        int n8 = n2 + 10 - 1;
        int n9 = n2 + 32 - 10;
        int n10 = n2 + 32 - 1;
        switch (direction) {
            case EAST: {
                n = n + 32 - 1;
                graphics2D.drawLine(n, n7, n, n8);
                graphics2D.drawLine(n, n8, n - 2, n8);
                graphics2D.drawLine(n - 2, n8, n - 2, n9);
                graphics2D.drawLine(n - 2, n9, n, n9);
                graphics2D.drawLine(n, n9, n, n10);
                break;
            }
            case NORTH: {
                graphics2D.drawLine(n3, n2, n4, n2);
                graphics2D.drawLine(n4, n2, n4, n2 + 2);
                graphics2D.drawLine(n4, n2 + 2, n5, n2 + 2);
                graphics2D.drawLine(n5, n2 + 2, n5, n2);
                graphics2D.drawLine(n5, n2, n6, n2);
                break;
            }
            case SOUTH: {
                n2 = n2 + 32 - 1;
                graphics2D.drawLine(n3, n2, n4, n2);
                graphics2D.drawLine(n4, n2, n4, n2 - 2);
                graphics2D.drawLine(n4, n2 - 2, n5, n2 - 2);
                graphics2D.drawLine(n5, n2 - 2, n5, n2);
                graphics2D.drawLine(n5, n2, n6, n2);
                break;
            }
            case WEST: {
                graphics2D.drawLine(n, n7, n, n8);
                graphics2D.drawLine(n, n8, n + 2, n8);
                graphics2D.drawLine(n + 2, n8, n + 2, n9);
                graphics2D.drawLine(n + 2, n9, n, n9);
                graphics2D.drawLine(n, n9, n, n10);
                break;
            }
        }
    }

    private void drawDoorLocked(Graphics2D graphics2D, int n, int n2, Direction direction) {
        switch (direction) {
            case EAST: {
                graphics2D.drawLine(n + 32 - 1, n2, n + 32 - 1, n2 + 10 - 1);
                graphics2D.fillRect(n + 32 - 3, n2 + 10, 3, 12);
                graphics2D.drawLine(n + 32 - 1, n2 + 32 - 10, n + 32 - 1, n2 + 32 - 1);
                break;
            }
            case NORTH: {
                graphics2D.drawLine(n, n2, n + 10 - 1, n2);
                graphics2D.fillRect(n + 10, n2, 12, 3);
                graphics2D.drawLine(n + 32 - 10, n2, n + 32 - 1, n2);
                break;
            }
            case SOUTH: {
                graphics2D.drawLine(n, n2 + 32 - 1, n + 10 - 1, n2 + 32 - 1);
                graphics2D.fillRect(n + 10, n2 + 32 - 3, 12, 3);
                graphics2D.drawLine(n + 32 - 10, n2 + 32 - 1, n + 32 - 1, n2 + 32 - 1);
                break;
            }
            case WEST: {
                graphics2D.drawLine(n, n2, n, n2 + 10 - 1);
                graphics2D.fillRect(n, n2 + 10, 3, 12);
                graphics2D.drawLine(n, n2 + 32 - 10, n, n2 + 32 - 1);
                break;
            }
        }
    }

    private void drawFloor(Graphics2D graphics2D, int n, int n2, Tile tile) {
        switch (tile.type) {
            case 0: {
                break;
            }
            case 1: {
                graphics2D.setColor(Color.BLUE.darker());
                graphics2D.fillRect(n, n2, 32, 32);
                break;
            }
            case 2: {
                graphics2D.setColor(Color.BLACK);
                for (int i = 0; i < 32; ++i) {
                    for (int j = 0; j < 32; ++j) {
                        if (i % 2 == 0) {
                            graphics2D.setColor(j % 2 == 0 ? Color.black : Color.blue.darker());
                        } else {
                            graphics2D.setColor(j % 2 == 0 ? Color.blue.darker() : Color.black);
                        }
                        graphics2D.fillRect(n + j, n2 + i, 1, 1);
                    }
                }
                break;
            }
        }
    }

    private void drawWall(Graphics2D graphics2D, int n, int n2, Direction direction) {
        switch (direction) {
            case EAST: {
                graphics2D.drawLine(n + 32 - 1, n2, n + 32 - 1, n2 + 32 - 1);
                break;
            }
            case NORTH: {
                graphics2D.drawLine(n, n2, n + 32 - 1, n2);
                break;
            }
            case SOUTH: {
                graphics2D.drawLine(n, n2 + 32 - 1, n + 32 - 1, n2 + 32 - 1);
                break;
            }
            case WEST: {
                graphics2D.drawLine(n, n2, n, n2 + 32 - 1);
                break;
            }
        }
    }

    private void drawWallEast(Graphics2D graphics2D, int n, int n2, TileEdge tileEdge) {
        switch (tileEdge.type) {
            case 1: 
            case 8: {
                this.drawWall(graphics2D, n, n2, Direction.EAST);
                break;
            }
            case 2: {
                this.drawDoor(graphics2D, n, n2, Direction.EAST);
                break;
            }
            case 3: {
                this.drawDoorLocked(graphics2D, n, n2, Direction.EAST);
                break;
            }
            case 4: {
                this.drawDoor(graphics2D, n, n2, Direction.EAST);
                break;
            }
            case 7: {
                this.drawWall(graphics2D, n, n2, Direction.EAST);
            }
        }
    }

    private void drawWallNorth(Graphics2D graphics2D, int n, int n2, TileEdge tileEdge) {
        switch (tileEdge.type) {
            case 1: 
            case 8: {
                this.drawWall(graphics2D, n, n2, Direction.NORTH);
                break;
            }
            case 2: {
                this.drawDoor(graphics2D, n, n2, Direction.NORTH);
                break;
            }
            case 3: {
                this.drawDoorLocked(graphics2D, n, n2, Direction.NORTH);
                break;
            }
            case 5: {
                this.drawDoor(graphics2D, n, n2, Direction.NORTH);
                break;
            }
            case 6: {
                this.drawWall(graphics2D, n, n2, Direction.NORTH);
            }
        }
    }

    private void drawWallSecret(Graphics2D graphics2D, int n, int n2, Direction direction) {
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(thindashed);
        switch (direction) {
            case EAST: {
                graphics2D.drawLine(n + 32 - 1, n2, n + 32 - 1, n2 + 32 - 1);
                break;
            }
            case NORTH: {
                graphics2D.drawLine(n, n2, n + 32 - 1, n2);
                break;
            }
            case SOUTH: {
                graphics2D.drawLine(n, n2 + 32 - 1, n + 32 - 1, n2 + 32 - 1);
                break;
            }
            case WEST: {
                graphics2D.drawLine(n, n2, n, n2 + 32 - 1);
                break;
            }
        }
        graphics2D.setStroke(stroke);
    }

    private void drawWallSouth(Graphics2D graphics2D, int n, int n2, TileEdge tileEdge) {
        switch (tileEdge.type) {
            case 1: 
            case 8: {
                this.drawWall(graphics2D, n, n2, Direction.SOUTH);
                break;
            }
            case 2: {
                this.drawDoor(graphics2D, n, n2, Direction.SOUTH);
                break;
            }
            case 3: {
                this.drawDoorLocked(graphics2D, n, n2, Direction.SOUTH);
                break;
            }
            case 5: {
                this.drawWall(graphics2D, n, n2, Direction.SOUTH);
                break;
            }
            case 6: {
                this.drawDoor(graphics2D, n, n2, Direction.SOUTH);
            }
        }
    }

    private void drawWallWest(Graphics2D graphics2D, int n, int n2, TileEdge tileEdge) {
        switch (tileEdge.type) {
            case 1: 
            case 8: {
                this.drawWall(graphics2D, n, n2, Direction.WEST);
                break;
            }
            case 2: {
                this.drawDoor(graphics2D, n, n2, Direction.WEST);
                break;
            }
            case 3: {
                this.drawDoorLocked(graphics2D, n, n2, Direction.WEST);
                break;
            }
            case 4: {
                this.drawWall(graphics2D, n, n2, Direction.WEST);
                break;
            }
            case 7: {
                this.drawDoor(graphics2D, n, n2, Direction.WEST);
            }
        }
    }

    public void paintComponent(Graphics graphics, Level level) {
        graphics.clearRect(0, 0, level.width * 32, level.height * 32);
        this.paintComponentGame0(graphics, level);
    }

    private void paintComponentGame0(Graphics graphics, Level level) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        for (int i = 0; i < level.height; ++i) {
            for (int j = 0; j < level.width; ++j) {
                Tile tile = level.tiles[j][i];
                if (tile == null) continue;
                int n = j * 32;
                int n2 = i * 32;
                this.drawFloor(graphics2D, n, n2, tile);
                graphics2D.setColor(this.wallColor);
                this.drawWallWest(graphics2D, n, n2, tile.edgeWest);
                this.drawWallNorth(graphics2D, n, n2, tile.edgeNorth);
                this.drawWallEast(graphics2D, n, n2, tile.edgeEast);
                this.drawWallSouth(graphics2D, n, n2, tile.edgeSouth);
            }
        }
    }

    @Deprecated
    private void paintComponentGame1(Graphics graphics, Level level, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        for (int i = 0; i < level.height; ++i) {
            block34: for (int j = 0; j < level.width; ++j) {
                Tile tile = level.tiles[j][i];
                if (tile == null) continue;
                int n = j * 32;
                int n2 = i * 32;
                if (bl) {
                    switch (tile.type) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            graphics2D.setColor(Color.BLUE.darker());
                            graphics2D.fillRect(n, n2, 32, 32);
                            break;
                        }
                        case 2: {
                            graphics2D.setColor(Color.BLACK);
                            for (int k = 0; k < 32; ++k) {
                                for (int i2 = 0; i2 < 32; ++i2) {
                                    if (k % 2 == 0) {
                                        graphics.setColor(i2 % 2 == 0 ? Color.black : Color.blue.darker());
                                    } else {
                                        graphics.setColor(i2 % 2 == 0 ? Color.blue.darker() : Color.black);
                                    }
                                    graphics.fillRect(n + i2, n2 + k, 1, 1);
                                }
                            }
                            break;
                        }
                    }
                }
                graphics2D.setColor(this.wallColor);
                switch (tile.edgeWest.type) {
                    case 1: 
                    case 8: {
                        this.drawWall(graphics2D, n, n2, Direction.WEST);
                        break;
                    }
                    case 2: {
                        this.drawDoor(graphics2D, n, n2, Direction.WEST);
                        break;
                    }
                    case 3: {
                        this.drawDoorLocked(graphics2D, n, n2, Direction.WEST);
                        break;
                    }
                    case 4: {
                        this.drawWall(graphics2D, n, n2, Direction.WEST);
                        break;
                    }
                    case 7: {
                        this.drawDoor(graphics2D, n, n2, Direction.WEST);
                    }
                }
                switch (tile.edgeNorth.type) {
                    case 1: 
                    case 8: {
                        this.drawWall(graphics2D, n, n2, Direction.NORTH);
                        break;
                    }
                    case 2: {
                        this.drawDoor(graphics2D, n, n2, Direction.NORTH);
                        break;
                    }
                    case 3: {
                        this.drawDoorLocked(graphics2D, n, n2, Direction.NORTH);
                        break;
                    }
                    case 5: {
                        this.drawDoor(graphics2D, n, n2, Direction.NORTH);
                        break;
                    }
                    case 6: {
                        this.drawWall(graphics2D, n, n2, Direction.NORTH);
                    }
                }
                switch (tile.edgeEast.type) {
                    case 1: 
                    case 8: {
                        this.drawWall(graphics2D, n, n2, Direction.EAST);
                        break;
                    }
                    case 2: {
                        this.drawDoor(graphics2D, n, n2, Direction.EAST);
                        break;
                    }
                    case 3: {
                        this.drawDoorLocked(graphics2D, n, n2, Direction.EAST);
                        break;
                    }
                    case 4: {
                        this.drawDoor(graphics2D, n, n2, Direction.EAST);
                        break;
                    }
                    case 7: {
                        this.drawWall(graphics2D, n, n2, Direction.EAST);
                    }
                }
                switch (tile.edgeSouth.type) {
                    case 1: 
                    case 8: {
                        this.drawWall(graphics2D, n, n2, Direction.SOUTH);
                        continue block34;
                    }
                    case 2: {
                        this.drawDoor(graphics2D, n, n2, Direction.SOUTH);
                        continue block34;
                    }
                    case 3: {
                        this.drawDoorLocked(graphics2D, n, n2, Direction.SOUTH);
                        continue block34;
                    }
                    case 5: {
                        this.drawWall(graphics2D, n, n2, Direction.SOUTH);
                        continue block34;
                    }
                    case 6: {
                        this.drawDoor(graphics2D, n, n2, Direction.SOUTH);
                    }
                }
            }
        }
    }

    private void paintVisibleWalls(Graphics graphics, Level level, int n, int n2, Direction direction) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Tile tile = level.getTile(n, n2);
        if (direction == Direction.NORTH) {
            if (tile.edgeNorth.type == 0 && n2 - 1 > 0) {
                Tile tile2 = level.getTile(n, n2 - 1);
                int n3 = n * 32;
                int n4 = (n2 - 1) * 32;
                this.drawWallNorth(graphics2D, n3, n4, tile2.edgeNorth);
                this.drawWallWest(graphics2D, n3, n4, tile2.edgeWest);
                this.drawWallEast(graphics2D, n3, n4, tile2.edgeEast);
            }
        } else if (direction == Direction.EAST) {
            if (tile.edgeEast.type == 0 && n + 1 < level.width) {
                Tile tile3 = level.getTile(n + 1, n2);
                int n5 = (n + 1) * 32;
                int n6 = n2 * 32;
                this.drawWallEast(graphics2D, n5, n6, tile3.edgeEast);
                this.drawWallNorth(graphics2D, n5, n6, tile3.edgeNorth);
                this.drawWallSouth(graphics2D, n5, n6, tile3.edgeSouth);
            }
        } else if (direction == Direction.SOUTH) {
            if (tile.edgeSouth.type == 0 && n2 + 1 < level.height) {
                Tile tile4 = level.getTile(n, n2 + 1);
                int n7 = n * 32;
                int n8 = (n2 + 1) * 32;
                this.drawWallSouth(graphics2D, n7, n8, tile4.edgeSouth);
                this.drawWallEast(graphics2D, n7, n8, tile4.edgeEast);
                this.drawWallWest(graphics2D, n7, n8, tile4.edgeWest);
            }
        } else if (direction == Direction.WEST && tile.edgeWest.type == 0 && n - 1 > 0) {
            Tile tile5 = level.getTile(n - 1, n2);
            int n9 = (n - 1) * 32;
            int n10 = n2 * 32;
            this.drawWallWest(graphics2D, n9, n10, tile5.edgeWest);
            this.drawWallNorth(graphics2D, n9, n10, tile5.edgeNorth);
            this.drawWallSouth(graphics2D, n9, n10, tile5.edgeSouth);
        }
    }
}

