/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.renderer;

import de.slashbinbash.hexen.enums.Direction;
import de.slashbinbash.hexen.map.Level;
import de.slashbinbash.hexen.map.Location;
import de.slashbinbash.hexen.map.Tile;
import de.slashbinbash.hexen.renderer.GLDraw3D;
import de.slashbinbash.opengl.Color;
import de.slashbinbash.opengl.GLByteBuffer;
import de.slashbinbash.opengl.Texture;
import de.slashbinbash.opengl.TextureFactory;
import de.slashbinbash.opengl.math.Math3D;
import java.io.File;
import java.io.IOException;
import org.joml.Matrix4f;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL33;

public class Map3DRenderer {
    public static Map3DRenderer _instance = null;
    public Matrix4f projection = null;
    public Matrix4f modelview = null;
    public GLDraw3D gl;
    public int TT_SIZE = 32;
    public Texture texFramebuffer = null;
    public int framebuffer = 0;
    public int depthbuffer = 0;
    public int FB_WIDTH = 160;
    public int FB_HEIGHT = 160;
    public Location location = null;
    public float rotator = 0.0f;
    private int dir = 0;
    public Texture texture = null;
    public final int TILE_SIZE = 32;

    public static Map3DRenderer getInstance() {
        if (_instance == null) {
            _instance = new Map3DRenderer();
        }
        return _instance;
    }

    public void init(GLByteBuffer gLByteBuffer) {
        Object object;
        this.gl = new GLDraw3D(gLByteBuffer);
        this.projection = new Matrix4f();
        this.modelview = new Matrix4f();
        try {
            object = new File("dcss_tileset.png");
            this.texture = ((File)object).exists() ? TextureFactory.createTexture((File)object) : TextureFactory.createTexture(128, 128, 6408);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.framebuffer = GL30.glGenFramebuffers();
        GL30.glBindFramebuffer((int)36160, (int)this.framebuffer);
        this.texFramebuffer = TextureFactory.createTexture(this.FB_WIDTH, this.FB_HEIGHT, 6408);
        this.depthbuffer = GL30.glGenRenderbuffers();
        GL30.glBindRenderbuffer((int)36161, (int)this.depthbuffer);
        GL30.glRenderbufferStorage((int)36161, (int)6402, (int)this.FB_WIDTH, (int)this.FB_HEIGHT);
        GL30.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)this.depthbuffer);
        GL33.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.texFramebuffer.id, (int)0);
        object = new int[]{36064};
        GL20.glDrawBuffers((int[])object);
        if (GL30.glCheckFramebufferStatus((int)36160) != 36053) {
            System.out.println("Framebuffer status incomplete");
        }
        GL30.glBindFramebuffer((int)36160, (int)0);
    }

    public void drawWall(Texture texture, int n, int n2, int n3, Direction direction) {
        int n4 = texture.width / this.TT_SIZE;
        int n5 = n % n4;
        int n6 = n / n4;
        int n7 = n5 * this.TT_SIZE;
        int n8 = n6 * this.TT_SIZE;
        int n9 = this.TT_SIZE;
        int n10 = this.TT_SIZE;
        this.drawWall(texture, n7, n8, n9, n10, n2, n3, direction);
    }

    public void drawWall(Texture texture, int n, int n2, int n3, int n4, int n5, int n6, Direction direction) {
        float f = (float)n / (float)texture.width;
        float f2 = (float)n2 / (float)texture.height;
        float f3 = (float)(n + n3) / (float)texture.width;
        float f4 = (float)(n2 + n4) / (float)texture.height;
        float f5 = n5;
        float f6 = n6;
        this.gl.tex = texture;
        switch (direction) {
            case DOWN: {
                this.gl.bufferTex(f5 + 0.0f, f6 + 0.0f, 0.0f, f, f2);
                this.gl.bufferTex(f5 + 0.0f, f6 + 1.0f, 0.0f, f, f4);
                this.gl.bufferTex(f5 + 1.0f, f6 + 0.0f, 0.0f, f3, f2);
                this.gl.bufferTex(f5 + 1.0f, f6 + 0.0f, 0.0f, f3, f2);
                this.gl.bufferTex(f5 + 0.0f, f6 + 1.0f, 0.0f, f, f4);
                this.gl.bufferTex(f5 + 1.0f, f6 + 1.0f, 0.0f, f3, f4);
                break;
            }
            case EAST: {
                this.gl.bufferTex(f5 + 1.0f, f6 + 0.0f, 1.0f, f, f2);
                this.gl.bufferTex(f5 + 1.0f, f6 + 0.0f, 0.0f, f, f4);
                this.gl.bufferTex(f5 + 1.0f, f6 + 1.0f, 1.0f, f3, f2);
                this.gl.bufferTex(f5 + 1.0f, f6 + 1.0f, 1.0f, f3, f2);
                this.gl.bufferTex(f5 + 1.0f, f6 + 0.0f, 0.0f, f, f4);
                this.gl.bufferTex(f5 + 1.0f, f6 + 1.0f, 0.0f, f3, f4);
                break;
            }
            case NORTH: {
                this.gl.bufferTex(f5 + 0.0f, f6 + 0.0f, 1.0f, f, f2);
                this.gl.bufferTex(f5 + 1.0f, f6 + 0.0f, 1.0f, f, f4);
                this.gl.bufferTex(f5 + 0.0f, f6 + 0.0f, 0.0f, f3, f2);
                this.gl.bufferTex(f5 + 0.0f, f6 + 0.0f, 0.0f, f3, f2);
                this.gl.bufferTex(f5 + 1.0f, f6 + 0.0f, 1.0f, f, f4);
                this.gl.bufferTex(f5 + 1.0f, f6 + 0.0f, 0.0f, f3, f4);
                break;
            }
            case SOUTH: {
                this.gl.bufferTex(f5 + 1.0f, f6 + 1.0f, 1.0f, f, f2);
                this.gl.bufferTex(f5 + 1.0f, f6 + 1.0f, 0.0f, f, f4);
                this.gl.bufferTex(f5 + 0.0f, f6 + 1.0f, 1.0f, f3, f2);
                this.gl.bufferTex(f5 + 0.0f, f6 + 1.0f, 1.0f, f3, f2);
                this.gl.bufferTex(f5 + 1.0f, f6 + 1.0f, 0.0f, f, f4);
                this.gl.bufferTex(f5 + 0.0f, f6 + 1.0f, 0.0f, f3, f4);
                break;
            }
            case UP: {
                break;
            }
            case WEST: {
                this.gl.bufferTex(f5 + 0.0f, f6 + 1.0f, 1.0f, f, f2);
                this.gl.bufferTex(f5 + 0.0f, f6 + 1.0f, 0.0f, f, f4);
                this.gl.bufferTex(f5 + 0.0f, f6 + 0.0f, 1.0f, f3, f2);
                this.gl.bufferTex(f5 + 0.0f, f6 + 0.0f, 1.0f, f3, f2);
                this.gl.bufferTex(f5 + 0.0f, f6 + 1.0f, 0.0f, f, f4);
                this.gl.bufferTex(f5 + 0.0f, f6 + 0.0f, 0.0f, f3, f4);
                break;
            }
        }
    }

    public void draw(boolean bl) {
        GL11.glViewport((int)0, (int)0, (int)this.FB_WIDTH, (int)this.FB_HEIGHT);
        GL11.glClear((int)16640);
        Math3D.setPerspectiveProjectionMatrix(75.0f, (float)this.FB_WIDTH / (float)this.FB_HEIGHT, 1.0E-4f, 10.0f, this.projection);
        this.gl.loadProjectionMatrix(this.projection);
        this.gl.loadIdentity();
        if (bl) {
            this.gl.scalef(1.0f, -1.0f, 1.0f);
        }
        this.gl.scalef(-1.0f, 1.0f, 1.0f);
        this.gl.rotatef((float)Math.toRadians(90.0), 0.0f, 0.0f, 1.0f);
        this.gl.rotatef((float)Math.toRadians(90.0), 0.0f, 1.0f, 0.0f);
        this.gl.rotatef((float)Math.toRadians(this.rotator), 0.0f, 0.0f, 1.0f);
        switch (this.dir) {
            case 0: {
                this.gl.translatef(-((float)this.location.x + 0.25f), -((float)this.location.y + 0.5f), -0.5f);
                break;
            }
            case 1: {
                this.gl.translatef(-((float)this.location.x + 0.5f), -((float)this.location.y + 0.25f), -0.5f);
                break;
            }
            case 2: {
                this.gl.translatef(-((float)this.location.x + 0.75f), -((float)this.location.y + 0.5f), -0.5f);
                break;
            }
            case 3: {
                this.gl.translatef(-((float)this.location.x + 0.5f), -((float)this.location.y + 0.75f), -0.5f);
                break;
            }
            default: {
                this.gl.translatef(-((float)this.location.x + 0.5f), -((float)this.location.y + 0.5f), -0.5f);
            }
        }
        Vector3f vector3f = new Vector3f();
        switch (this.dir) {
            case 0: {
                vector3f.set(1.0f, 0.0f, 0.0f);
                break;
            }
            case 1: {
                vector3f.set(0.0f, 1.0f, 0.0f);
                break;
            }
            case 2: {
                vector3f.set(-1.0f, 0.0f, 0.0f);
                break;
            }
            case 3: {
                vector3f.set(0.0f, -1.0f, 0.0f);
            }
        }
        GL11.glEnable((int)2929);
        this.gl.setColor(Color.RED);
        this.gl.drawLine(0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        this.gl.setColor(Color.GREEN);
        this.gl.drawLine(0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        this.gl.setColor(Color.BLUE);
        this.gl.drawLine(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        this.gl.setColor(Color.WHITE);
        if (this.location != null) {
            Level level = this.location.getLevel();
            this.gl.begin(3);
            for (int i = -3; i <= 3; ++i) {
                for (int j = -3; j <= 3; ++j) {
                    int n = this.location.x + i;
                    int n2 = this.location.y + j;
                    if (0 > n || n >= level.width || 0 > n2 || n2 >= level.height || level.tiles[n][n2] == null) continue;
                    boolean bl2 = false;
                    if (bl2) {
                        int n3 = (int)Vector2i.distance(this.location.x, this.location.y, this.location.x + i, this.location.y + j);
                        switch (n3) {
                            case 0: {
                                this.gl.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                                break;
                            }
                            case 1: {
                                this.gl.setColor(0.9f, 0.9f, 0.9f, 1.0f);
                                break;
                            }
                            case 2: {
                                this.gl.setColor(0.5f, 0.5f, 0.5f, 1.0f);
                                break;
                            }
                            case 3: {
                                this.gl.setColor(0.25f, 0.25f, 0.25f, 1.0f);
                                break;
                            }
                            default: {
                                this.gl.setColor(Color.BLACK);
                                break;
                            }
                        }
                    } else {
                        this.gl.setColor(Color.WHITE);
                    }
                    this.drawWall(this.texture, 5, n, n2, Direction.DOWN);
                    Tile tile = level.tiles[n][n2];
                    if (tile.edgeEast != null && tile.edgeEast.type != 0) {
                        this.drawWall(this.texture, 6, n, n2, Direction.EAST);
                    }
                    if (tile.edgeNorth != null && tile.edgeNorth.type != 0) {
                        this.drawWall(this.texture, 7, n, n2, Direction.NORTH);
                    }
                    if (tile.edgeSouth != null && tile.edgeSouth.type != 0) {
                        this.drawWall(this.texture, 8, n, n2, Direction.SOUTH);
                    }
                    if (tile.edgeWest == null || tile.edgeWest.type == 0) continue;
                    this.drawWall(this.texture, 9, n, n2, Direction.WEST);
                }
            }
            this.gl.end();
        }
        GL11.glDisable((int)2929);
    }

    public Texture renderToTarget() {
        GL30.glBindFramebuffer((int)36160, (int)this.framebuffer);
        this.draw(true);
        GL30.glBindFramebuffer((int)36160, (int)0);
        return this.texFramebuffer;
    }
}

