/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.renderer;

import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.map.Level;
import de.slashbinbash.hexen.map.Location;
import de.slashbinbash.hexen.map.Tile;
import de.slashbinbash.opengl.Color;
import de.slashbinbash.opengl.Texture;
import de.slashbinbash.opengl.TextureFactory;
import de.slashbinbash.opengl.renderer.Draw2D;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class MapIsoRenderer {
    private static MapIsoRenderer _instance;
    private final int SIZE = 32;
    private final int WALL_H = 0;
    private final int WALL_V = 1;
    private final int DOOR_H = 2;
    private final int DOOR_V = 3;
    private final int FLOOR = 4;
    private final int ROOM = 5;
    private String texId = null;
    private BufferedImage img = null;
    private Texture tex = null;
    private Tt[][] tts = null;
    public boolean restrictView = false;

    public static MapIsoRenderer getInstance() {
        if (_instance == null) {
            _instance = new MapIsoRenderer();
        }
        return _instance;
    }

    public static Tt[][] readTs(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        Tt[][] ttArray = new Tt[6][];
        for (int i = 0; i < 6; ++i) {
            ArrayList<Tt> arrayList = new ArrayList<Tt>();
            String string = null;
            while ((string = bufferedReader.readLine()) != null && !string.isEmpty()) {
                String[] stringArray = string.trim().split(" ");
                int n = Integer.valueOf(stringArray[0]);
                int n2 = Integer.valueOf(stringArray[1]);
                int n3 = Integer.valueOf(stringArray[2]);
                int n4 = Integer.valueOf(stringArray[3]);
                int n5 = Integer.valueOf(stringArray[4]);
                int n6 = Integer.valueOf(stringArray[5]);
                Tt tt = new Tt(n, n2, n3, n4, n5, n6);
                arrayList.add(tt);
            }
            ttArray[i] = arrayList.toArray(new Tt[0]);
        }
        bufferedReader.close();
        return ttArray;
    }

    private MapIsoRenderer() {
    }

    public void load(File file, File file2) throws IOException {
        this.img = ImageIO.read(file);
        this.tts = MapIsoRenderer.readTs(file2);
    }

    private void paint(Graphics2D graphics2D, int n, int n2, Tt tt) {
        int n3 = n + tt.dstOffX;
        int n4 = n2 + tt.dstOffY;
        int n5 = n3 + tt.srcWidth;
        int n6 = n4 + tt.srcHeight;
        int n7 = tt.srcX;
        int n8 = tt.srcY;
        int n9 = n7 + tt.srcWidth;
        int n10 = n8 + tt.srcHeight;
        graphics2D.drawImage(this.img, n3, n4, n5, n6, n7, n8, n9, n10, null);
    }

    private void paint(Draw2D draw2D, int n, int n2, Tt tt) {
        int n3 = tt.srcX;
        int n4 = tt.srcY;
        int n5 = tt.srcWidth;
        int n6 = tt.srcHeight;
        float f = n + tt.dstOffX;
        float f2 = n2 + tt.dstOffY;
        float f3 = tt.srcWidth;
        float f4 = tt.srcHeight;
        draw2D.drawTexture(this.tex, n3, n4, n5, n6, f, f2, f3, f4);
    }

    public void draw(Draw2D draw2D, Level level, int n, int n2) {
        assert (level.texId.equals(this.texId));
        int n3 = Math.max(0, n - 3);
        int n4 = Math.min(level.width - 1, n + 3);
        int n5 = Math.max(0, n2 - 3);
        int n6 = Math.min(level.height - 1, n2 + 3);
        if (this.restrictView) {
            n3 = n;
            n4 = n;
            n5 = n2;
            n6 = n2;
        }
        draw2D.setColor(Color.WHITE);
        for (int i = n5; i <= n6; ++i) {
            block17: for (int j = n3; j <= n4; ++j) {
                Tt tt;
                boolean bl;
                boolean bl2;
                Tile tile = level.tiles[j][i];
                if (tile == null) continue;
                if (level.visited[j][i]) {
                    draw2D.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                } else {
                    draw2D.setColor(0.9f, 0.9f, 0.9f, 1.0f);
                }
                int n7 = j * 32;
                int n8 = i * 32;
                boolean bl3 = bl2 = level.visibility[j][i];
                boolean bl4 = bl2;
                boolean bl5 = bl2 || i > 0 && level.visibility[j][i - 1];
                boolean bl6 = bl2 || j > 0 && level.visibility[j - 1][i];
                boolean bl7 = j == n4 && (bl2 || j + 1 < level.width && level.visibility[j + 1][i]);
                boolean bl8 = bl = i == n6 && (bl2 || i + 1 < level.height && level.visibility[j][i + 1]);
                if (bl3 && (tile.type == 1 || tile.type == 2)) {
                    tt = this.tts[4][tile.texFloor];
                    this.paint(draw2D, n7, n8, tt);
                }
                if (bl5) {
                    switch (tile.edgeNorth.type) {
                        case 1: 
                        case 6: 
                        case 8: {
                            if (tile.edgeNorth.texEdge >= this.tts[0].length) break;
                            tt = this.tts[0][tile.edgeNorth.texEdge];
                            this.paint(draw2D, n7, n8, tt);
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 5: {
                            if (tile.edgeNorth.texEdge >= this.tts[2].length) break;
                            tt = this.tts[2][tile.edgeNorth.texEdge];
                            this.paint(draw2D, n7, n8, tt);
                        }
                    }
                }
                if (bl6) {
                    switch (tile.edgeWest.type) {
                        case 1: 
                        case 8: {
                            if (tile.edgeWest.texEdge >= this.tts[1].length) break;
                            tt = this.tts[1][tile.edgeWest.texEdge];
                            this.paint(draw2D, n7, n8, tt);
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: {
                            if (tile.edgeWest.texEdge >= this.tts[3].length) break;
                            tt = this.tts[3][tile.edgeWest.texEdge];
                            this.paint(draw2D, n7, n8, tt);
                        }
                    }
                }
                if (bl4 && tile.texRoom < this.tts[5].length) {
                    tt = this.tts[5][tile.texRoom];
                    this.paint(draw2D, n7, n8, tt);
                }
                if (bl7) {
                    switch (tile.edgeEast.type) {
                        case 1: 
                        case 8: {
                            if (tile.edgeEast.texEdge >= this.tts[1].length) break;
                            tt = this.tts[1][tile.edgeEast.texEdge];
                            this.paint(draw2D, n7 + 32, n8, tt);
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: {
                            if (tile.edgeEast.texEdge >= this.tts[3].length) break;
                            tt = this.tts[3][tile.edgeEast.texEdge];
                            this.paint(draw2D, n7 + 32, n8, tt);
                        }
                    }
                }
                if (!bl) continue;
                switch (tile.edgeSouth.type) {
                    case 1: 
                    case 6: 
                    case 8: {
                        if (tile.edgeSouth.texEdge >= this.tts[0].length) continue block17;
                        tt = this.tts[0][tile.edgeSouth.texEdge];
                        this.paint(draw2D, n7, n8 + 32, tt);
                        continue block17;
                    }
                    case 2: 
                    case 3: 
                    case 5: {
                        if (tile.edgeSouth.texEdge >= this.tts[2].length) continue block17;
                        tt = this.tts[2][tile.edgeSouth.texEdge];
                        this.paint(draw2D, n7, n8 + 32, tt);
                    }
                }
            }
        }
    }

    public void paintComponent(Graphics2D graphics2D, Level level) {
        for (int i = 0; i < level.height; ++i) {
            for (int j = 0; j < level.width; ++j) {
                Tt tt;
                Tile tile = level.tiles[j][i];
                if (tile == null) continue;
                int n = j * 32;
                int n2 = i * 32;
                if (tile.type == 1 && tile.texFloor < this.tts[4].length) {
                    tt = this.tts[4][tile.texFloor];
                    this.paint(graphics2D, n, n2, tt);
                }
                switch (tile.edgeNorth.type) {
                    case 1: 
                    case 6: 
                    case 8: {
                        if (tile.edgeNorth.texEdge >= this.tts[0].length) break;
                        tt = this.tts[0][tile.edgeNorth.texEdge];
                        this.paint(graphics2D, n, n2, tt);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: {
                        if (tile.edgeNorth.texEdge >= this.tts[2].length) break;
                        tt = this.tts[2][tile.edgeNorth.texEdge];
                        this.paint(graphics2D, n, n2, tt);
                    }
                }
                switch (tile.edgeWest.type) {
                    case 1: 
                    case 8: {
                        if (tile.edgeWest.texEdge >= this.tts[1].length) break;
                        tt = this.tts[1][tile.edgeWest.texEdge];
                        this.paint(graphics2D, n, n2, tt);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: {
                        if (tile.edgeWest.texEdge >= this.tts[3].length) break;
                        tt = this.tts[3][tile.edgeWest.texEdge];
                        this.paint(graphics2D, n, n2, tt);
                    }
                }
                if (tile.texRoom >= this.tts[5].length) continue;
                tt = this.tts[5][tile.texRoom];
                this.paint(graphics2D, n, n2, tt);
            }
        }
    }

    public void update(Location location) {
        Level level = location.getLevel();
        if (this.texId != level.texId || level.texId == null) {
            this.img = null;
            if (this.tex != null) {
                TextureFactory.deleteTexture(this.tex);
                this.tex = null;
            }
            this.tts = null;
            this.texId = null;
        }
        if (level.texId != null && this.texId != level.texId) {
            try {
                String string = Factory.MAPIMG_PATH + level.texId;
                this.img = ImageIO.read(new File(string + ".png"));
                this.tex = TextureFactory.createTexture(this.img);
                this.tts = MapIsoRenderer.readTs(new File(string + ".txt"));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.texId = level.texId;
        }
    }

    public static class Tt {
        public int srcHeight;
        public int srcWidth;
        public int srcX;
        public int srcY;
        public int dstOffX;
        public int dstOffY;

        public Tt(int n, int n2, int n3, int n4, int n5, int n6) {
            this.srcX = n;
            this.srcY = n2;
            this.srcWidth = n3;
            this.srcHeight = n4;
            this.dstOffX = n5;
            this.dstOffY = n6;
        }
    }
}

