/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.renderer;

import de.slashbinbash.hexen.enums.Direction;
import de.slashbinbash.hexen.factory.Factory;
import de.slashbinbash.hexen.map.Level;
import de.slashbinbash.hexen.map.Location;
import de.slashbinbash.hexen.renderer.LevelRenderer;
import de.slashbinbash.hexen.renderer.Util;
import de.slashbinbash.opengl.Color;
import de.slashbinbash.opengl.Texture;
import de.slashbinbash.opengl.TextureFactory;
import de.slashbinbash.opengl.renderer.Draw2D;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class MapRenderer {
    private static MapRenderer _instance = null;
    private static float[] fillColor = Color.BLACK;
    private final int TILE_SIZE = 32;
    private LevelRenderer levelRenderer = new LevelRenderer();
    private String keyLevel = null;
    private Texture texBackground = null;
    private Texture texGrayground = null;
    private boolean wrap = true;
    public boolean restrictView = false;
    public boolean hideLevel = false;
    public Direction direction = null;
    private boolean[][] m_visibility = null;
    private boolean[][] m_visited = null;

    public static MapRenderer getInstance() {
        if (_instance == null) {
            _instance = new MapRenderer();
        }
        return _instance;
    }

    public void draw(Draw2D draw2D, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = n;
        float f4 = n2;
        draw2D.setColor(fillColor);
        draw2D.fillRect(f, f2, f3, f4);
        if (!this.hideLevel) {
            n6 = n;
            n5 = n2;
            int n7 = (n3 - 3) * 32;
            int n8 = (n4 - 3) * 32;
            draw2D.setColor(Color.WHITE);
            draw2D.drawTexture(this.texBackground, n7, n8, n6, n5, f, f2, f3, f4);
            this.drawVisibility(draw2D, n3, n4, f, f2);
        }
        if (this.restrictView) {
            for (n6 = -3; n6 <= 3; ++n6) {
                for (n5 = -3; n5 <= 3; ++n5) {
                    if (n5 == 0 && n6 == 0) continue;
                    draw2D.setColor(Color.BLACK);
                    draw2D.fillRect((n5 + 3) * 32, (n6 + 3) * 32, 32.0f, 32.0f);
                }
            }
        }
        if (this.direction != null) {
            draw2D.setColor(Color.RED);
            float f5 = f3 * 0.5f - 4.0f;
            float f6 = f4 * 0.5f - 4.0f;
            switch (this.direction) {
                case EAST: {
                    draw2D.fillPolygon(f5, f6, f5 + 8.0f, f6 + 4.0f, f5, f6 + 8.0f);
                    break;
                }
                case NORTH: {
                    draw2D.fillPolygon(f5 + 4.0f, f6, f5 + 8.0f, f6 + 8.0f, f5, f6 + 8.0f);
                    break;
                }
                case SOUTH: {
                    draw2D.fillPolygon(f5, f6, f5 + 8.0f, f6, f5 + 4.0f, f6 + 8.0f);
                    break;
                }
                case WEST: {
                    draw2D.fillPolygon(f5, f6 + 4.0f, f5 + 8.0f, f6, f5 + 8.0f, f6 + 8.0f);
                    break;
                }
                default: {
                    draw2D.fillRect(f3 * 0.5f - 4.0f, f4 * 0.5f - 4.0f, 8.0f, 8.0f);
                    break;
                }
            }
        } else {
            draw2D.setColor(Color.RED);
            draw2D.fillRect(f3 * 0.5f - 4.0f, f4 * 0.5f - 4.0f, 8.0f, 8.0f);
        }
    }

    private BufferedImage createGrayImage(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        Graphics graphics = bufferedImage2.getGraphics();
        graphics.drawImage(bufferedImage, 0, 0, null);
        DataBuffer dataBuffer = bufferedImage2.getRaster().getDataBuffer();
        for (int i = 0; i < dataBuffer.getSize(); ++i) {
            int n = dataBuffer.getElem(i);
            dataBuffer.setElem(i, this.grayscale(n));
        }
        return bufferedImage2;
    }

    private void drawVisibility(Draw2D draw2D, int n, int n2, float f, float f2) {
        boolean bl;
        boolean bl2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (this.m_visibility == null || this.m_visited == null) {
            return;
        }
        int n7 = this.m_visibility.length;
        int n8 = this.m_visibility[0].length;
        draw2D.begin();
        for (n6 = -3; n6 <= 3; ++n6) {
            for (n5 = -3; n5 <= 3; ++n5) {
                n4 = n + n5;
                n3 = n2 + n6;
                if (this.wrap) {
                    n4 = Util.wrap(n4, 0, n7);
                    n3 = Util.wrap(n3, 0, n8);
                }
                if (!(0 <= n4 && n4 < n7 && 0 <= n3 && n3 < n8)) continue;
                bl2 = this.m_visibility[n4][n3];
                bl = this.m_visited[n4][n3];
                if (!bl2 || bl) continue;
                int n9 = n4 * 32;
                int n10 = n3 * 32;
                int n11 = 32;
                int n12 = 32;
                float f3 = (n5 + 3) * 32;
                float f4 = (n6 + 3) * 32;
                float f5 = 32.0f;
                float f6 = 32.0f;
                draw2D.drawTexture(this.texGrayground, n9, n10, n11, n12, f3, f4, f5, f6);
            }
        }
        draw2D.end();
        draw2D.begin();
        for (n6 = -3; n6 <= 3; ++n6) {
            for (n5 = -3; n5 <= 3; ++n5) {
                n4 = n + n5;
                n3 = n2 + n6;
                if (this.wrap) {
                    n4 = Util.wrap(n4, 0, n7);
                    n3 = Util.wrap(n3, 0, n8);
                }
                if (!(0 <= n4 && n4 < n7 && 0 <= n3 && n3 < n8)) continue;
                bl2 = this.m_visibility[n4][n3];
                bl = this.m_visited[n4][n3];
                if (bl2 || bl) continue;
                draw2D.setColor(Color.BLACK);
                draw2D.fillRect((n5 + 3) * 32, (n6 + 3) * 32, 32.0f, 32.0f);
            }
        }
        draw2D.end();
    }

    private int grayscale(int n) {
        float f = (float)Util.getRed(n) * 30.0f / 100.0f;
        float f2 = (float)Util.getGreen(n) * 59.0f / 100.0f;
        float f3 = (float)Util.getBlue(n) * 11.0f / 100.0f;
        int n2 = (int)(f + f2 + f3);
        assert (0 <= n2 && n2 < 256) : n2;
        return 0xFF000000 | n2 << 16 | n2 << 8 | n2;
    }

    public void update(Location location) {
        Object object;
        String string = "auto_" + location.map.__id__ + "_" + location.level;
        if (this.keyLevel != null && this.keyLevel.equals(string)) {
            return;
        }
        Level level = location.getLevel();
        this.wrap = level.loop;
        this.m_visibility = level.visibility;
        this.m_visited = level.visited;
        if (this.keyLevel != null) {
            TextureFactory.deleteTexture(this.texBackground);
            TextureFactory.deleteTexture(this.texGrayground);
            this.texBackground = null;
            this.texGrayground = null;
            this.keyLevel = null;
        }
        BufferedImage bufferedImage = null;
        if (level.image != null) {
            try {
                object = Factory.MAPIMG_PATH + level.image + ".png";
                bufferedImage = ImageIO.read(new File((String)object));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(-1);
            }
        } else {
            bufferedImage = new BufferedImage(level.width * 32, level.height * 32, 2);
            this.levelRenderer.paintComponent(bufferedImage.getGraphics(), level);
        }
        object = this.createGrayImage(bufferedImage);
        this.texBackground = TextureFactory.createTexture(bufferedImage, this.wrap ? 10497 : 33069);
        this.texGrayground = TextureFactory.createTexture((BufferedImage)object);
        this.keyLevel = string;
    }
}

