/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.shop;

import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.StaticRPG;
import de.slashbinbash.hexen.model.Inventory;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.shop.Buy;
import de.slashbinbash.hexen.shop.Sell;

public class StaticShop {
    public static Result buyItem(Buy.Data data, Item item, int n) {
        int n2 = data.getBuyPrice(item, n);
        if (data.currency == null) {
            return StaticShop.buyItem(item, n2);
        }
        return StaticShop.buyItem(item, data.currency, n2);
    }

    public static Result buyItem(Item item, int n) {
        Inventory inventory = RPG.getInstance().party.inventory;
        if (inventory.getCurrency() < n) {
            return Result.FAIL;
        }
        inventory.removeCurrency(n);
        inventory.add(item.getId(), 1);
        return Result.OK;
    }

    public static Result buyItem(Item item, String string, int n) {
        Inventory inventory = RPG.getInstance().party.inventory;
        if (inventory.count(string) < n) {
            return Result.FAIL;
        }
        inventory.remove(string, n);
        inventory.add(item.getId(), 1);
        return Result.OK;
    }

    public static boolean canSell(Sell.Data data, Item item) {
        if (!item.isSellable()) {
            return false;
        }
        if (data.currency != null && item.getId().equals(data.currency)) {
            return false;
        }
        return !StaticRPG.isEquipped(item);
    }

    public static Result sellItem(Item item, int n, String string, int n2) {
        Inventory inventory = RPG.getInstance().party.inventory;
        int n3 = inventory.remove(item, n);
        if (n3 > 0) {
            if (string != null) {
                inventory.add(string, n3 * n2);
            } else {
                inventory.addCurrency(n3 * n2);
            }
        }
        return Result.OK;
    }

    public static Result sellItem(String string, int n, String string2, int n2) {
        Inventory inventory = RPG.getInstance().party.inventory;
        int n3 = inventory.remove(string, n);
        if (n3 > 0) {
            if (string2 != null) {
                inventory.add(string2, n3 * n2);
            } else {
                inventory.addCurrency(n3 * n2);
            }
        }
        return Result.OK;
    }

    public static enum Result {
        OK,
        FAIL,
        INVENTORY_FULL;

    }
}

