/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.hexen.view;

import de.slashbinbash.hexen.CommandEvent;
import de.slashbinbash.hexen.Hexen;
import de.slashbinbash.hexen.RPG;
import de.slashbinbash.hexen.action.StaticAction;
import de.slashbinbash.hexen.check.AbilityCheck;
import de.slashbinbash.hexen.check.Checks;
import de.slashbinbash.hexen.check.ICheck;
import de.slashbinbash.hexen.check.LearnCombatActionCheck;
import de.slashbinbash.hexen.check.TraitCheck;
import de.slashbinbash.hexen.combat.StaticCombat;
import de.slashbinbash.hexen.enums.Ability;
import de.slashbinbash.hexen.enums.Attribute;
import de.slashbinbash.hexen.enums.Component;
import de.slashbinbash.hexen.enums.DamageType;
import de.slashbinbash.hexen.factory.CombatLevelsFactory;
import de.slashbinbash.hexen.log.EventLog;
import de.slashbinbash.hexen.map.Location;
import de.slashbinbash.hexen.model.Abilities;
import de.slashbinbash.hexen.model.Attributes;
import de.slashbinbash.hexen.model.ClassCreature;
import de.slashbinbash.hexen.model.CombatAction;
import de.slashbinbash.hexen.model.Condition;
import de.slashbinbash.hexen.model.ConditionImmunities;
import de.slashbinbash.hexen.model.ConditionImmunity;
import de.slashbinbash.hexen.model.Damage;
import de.slashbinbash.hexen.model.DamageReductions;
import de.slashbinbash.hexen.model.DamageResistances;
import de.slashbinbash.hexen.model.Duration;
import de.slashbinbash.hexen.model.Item;
import de.slashbinbash.hexen.model.ItemGroup;
import de.slashbinbash.hexen.model.Modifiers;
import de.slashbinbash.hexen.model.Party;
import de.slashbinbash.hexen.model.Recipe;
import de.slashbinbash.hexen.model.Scene;
import de.slashbinbash.hexen.model.Slot;
import de.slashbinbash.hexen.model.Slots;
import de.slashbinbash.hexen.model.Trait;
import de.slashbinbash.hexen.renderer.BackgroundRenderer;
import de.slashbinbash.hexen.renderer.PortraitRenderer;
import de.slashbinbash.hexen.ui.Button;
import de.slashbinbash.opengl.Color;
import de.slashbinbash.opengl.math.Rect2f;
import de.slashbinbash.opengl.renderer.Draw2D;
import java.util.List;
import java.util.Map;

public class StaticView {
    public static final int BOTTOM_RECT_Y = 256;
    public static final Rect2f LEFT_COLUMN = new Rect2f(192.0f, 16.0f, 224.0f, 224.0f);
    public static final Rect2f RIGHT_COLUMN = new Rect2f(LEFT_COLUMN.right() + 16.0f, LEFT_COLUMN.top(), StaticView.LEFT_COLUMN.width, StaticView.LEFT_COLUMN.height);
    public static final int WRAP_COLUMN_LEFT = 28;
    public static final int WRAP_COLUMN_RIGHT = 24;
    public static final int WRAP_SCREEN = 54;
    public static final Rect2f PORTRAIT_RECT = new Rect2f(16.0f, 16.0f, 160.0f, 160.0f);
    public static final String CURRENCY = "currency";
    public static int conditionCycle = 0;

    public static Button addButton(List<Button> list) {
        return StaticView.addButton(list, new Button());
    }

    public static Button addButton(List<Button> list, Button button) {
        Rect2f rect2f = LEFT_COLUMN;
        Rect2f rect2f2 = new Rect2f(rect2f.x, rect2f.y, rect2f.width, 8.0f);
        if (list.isEmpty()) {
            button.rect = new Rect2f(rect2f2);
            list.add(button);
            return button;
        }
        Button button2 = list.get(list.size() - 1);
        button.rect = new Rect2f(rect2f2.x, button2.rect.bottom(), rect2f2.width, rect2f2.height);
        list.add(button);
        return button;
    }

    public static Button addButton(List<Button> list, String string) {
        Button button = StaticView.addButton(list);
        button.label = string;
        return button;
    }

    public static Button addButton(List<Button> list, String string, CommandEvent commandEvent) {
        Button button = StaticView.addButton(list);
        button.label = string;
        button.command = commandEvent;
        return button;
    }

    public static Button addButton(List<Button> list, String string, Object object) {
        Button button = StaticView.addButton(list);
        button.label = string;
        button.data = object;
        return button;
    }

    public static void addButtons(List<Button> list, List<Button> list2) {
        for (Button button : list2) {
            StaticView.addButton(list, button);
        }
    }

    public static void drawBackground(Draw2D draw2D) {
        BackgroundRenderer.draw(draw2D);
    }

    public static void drawBottomPane(Draw2D draw2D) {
        StaticView.drawBottomRect(draw2D);
        StaticView.drawParty(draw2D);
        StaticView.drawEventLog(draw2D);
    }

    public static void drawBottomRect(Draw2D draw2D) {
        draw2D.setColor(Color.GREY);
        draw2D.fillRect(0.0f, 256.0f, Hexen.SCR_WIDTH, Hexen.SCR_HEIGHT - 256);
    }

    public static void drawBottomText(Draw2D draw2D, String string) {
        if (string != null) {
            draw2D.setColor(Color.BLACK);
            draw2D.drawString(8.0f, 264.0f, string);
        }
    }

    public static void drawEventLog(Draw2D draw2D) {
        RPG rPG = RPG.getInstance();
        EventLog eventLog = rPG.logSystem.eventLog;
        StringBuilder stringBuilder = new StringBuilder();
        eventLog.print(stringBuilder, 11);
        draw2D.setColor(Color.BLACK);
        draw2D.drawString(328.0f, 264.0f, stringBuilder.toString());
    }

    public static void drawParty(Draw2D draw2D) {
        StringBuilder stringBuilder = new StringBuilder();
        StaticView.printParty(stringBuilder, RPG.getInstance().party);
        StaticView.drawBottomText(draw2D, stringBuilder.toString());
    }

    public static void drawPortrait(Draw2D draw2D) {
        PortraitRenderer.draw(draw2D, null);
        StaticView.drawPortraitTitle(draw2D, "");
    }

    public static void drawPortrait(Draw2D draw2D, ClassCreature classCreature) {
        PortraitRenderer.draw(draw2D, classCreature.portrait);
        StaticView.drawPortraitTitle(draw2D, classCreature.name);
    }

    public static void drawPortrait(Draw2D draw2D, Item item) {
        PortraitRenderer.draw(draw2D, item._data.portrait);
        StaticView.drawPortraitTitle(draw2D, item.getName());
    }

    public static void drawPortrait(Draw2D draw2D, Scene scene) {
        String string = scene != null ? scene.portrait : null;
        String string2 = scene != null ? scene.portraitTitle : null;
        PortraitRenderer.draw(draw2D, string);
        StaticView.drawPortraitTitle(draw2D, string2);
    }

    public static void drawPortrait(Draw2D draw2D, String string, String string2) {
        PortraitRenderer.draw(draw2D, string);
        StaticView.drawPortraitTitle(draw2D, string2);
    }

    private static void drawPortraitTitle(Draw2D draw2D, String string) {
        Rect2f rect2f = PORTRAIT_RECT;
        draw2D.setColor(Color.BLACK);
        draw2D.fillRect(rect2f.left(), rect2f.bottom(), rect2f.width, 16.0f);
        if (string == null) {
            return;
        }
        draw2D.setColor(Color.WHITE);
        draw2D.drawString(rect2f.left() + 8.0f, rect2f.bottom() + 4.0f, string);
    }

    public static void drawStatusBar(Draw2D draw2D) {
        RPG rPG = RPG.getInstance();
        Location location = rPG.party.getLocation();
        int n = (int)(rPG.timeSeconds % 86400L / 3600L);
        int n2 = (int)(rPG.timeSeconds / 60L % 60L);
        draw2D.setColor(Color.WHITE);
        draw2D.drawString(0.0f, 0.0f, String.format("(%d,%d) %02d:%02d $%d", location.x, location.y, n, n2, rPG.party.inventory.getCurrency()));
    }

    public static void layout(List<Button> list) {
        Rect2f rect2f = LEFT_COLUMN;
        for (int i = 0; i < list.size(); ++i) {
            Button button = list.get(i);
            if (i == 0) {
                button.rect.x = rect2f.x;
                button.rect.y = rect2f.y;
                continue;
            }
            Button button2 = list.get(i - 1);
            button.rect.x = rect2f.x;
            button.rect.y = button2.rect.bottom();
        }
    }

    public static int percent(float f) {
        return (int)(f * 100.0f);
    }

    public static String percents(float f) {
        return String.format("%+d", StaticView.percent(f));
    }

    public static int pickButton(List<Button> list, char c) {
        for (int i = 0; i < list.size(); ++i) {
            Button button = list.get(i);
            if (button.label.charAt(0) != c) continue;
            return i;
        }
        return -1;
    }

    public static void printAbilities(StringBuilder stringBuilder, Abilities abilities, boolean bl, boolean bl2) {
        if (bl) {
            stringBuilder.append("ABILITIES");
        }
        if (abilities == null) {
            stringBuilder.append("\n-");
            return;
        }
        for (Map.Entry<Ability, Integer> entry : abilities.entrySet()) {
            String string = entry.getKey().name;
            int n = entry.getValue();
            if (n == 0) continue;
            if (bl2) {
                stringBuilder.append(String.format("\n%-14s %+3d", string, n));
                continue;
            }
            stringBuilder.append(String.format("\n%-14s %3d", string, n));
        }
    }

    public static void printAbilities(StringBuilder stringBuilder, ClassCreature classCreature, boolean bl) {
        if (bl) {
            stringBuilder.append("ABILITIES");
        }
        if (classCreature == null) {
            stringBuilder.append("\n-");
            return;
        }
        for (Ability ability : Ability.sortedView()) {
            int n = classCreature.calcAbilityScore(ability);
            if (n == 0) continue;
            stringBuilder.append(String.format("\n%-14s %3d", ability.name, n));
        }
    }

    public static void printAttributes(StringBuilder stringBuilder, Attributes attributes, boolean bl, boolean bl2) {
        if (bl) {
            stringBuilder.append("ATTRIBUTES");
        }
        if (attributes == null) {
            stringBuilder.append("\n-");
            return;
        }
        for (Map.Entry<Attribute, Integer> entry : attributes.entrySet()) {
            int n = entry.getValue();
            if (n == 0) continue;
            if (bl2) {
                stringBuilder.append(String.format("\n%-14s %+3d", entry.getKey().name, n));
                continue;
            }
            stringBuilder.append(String.format("\n%-14s %3d", entry.getKey().name, n));
        }
    }

    public static void printAttributes(StringBuilder stringBuilder, ClassCreature classCreature, boolean bl) {
        if (bl) {
            stringBuilder.append("ATTRIBUTES");
        }
        if (classCreature == null) {
            stringBuilder.append("\n-");
            return;
        }
        boolean bl2 = false;
        for (Attribute attribute : Attribute.values()) {
            int n = classCreature.calcAttributeScore(attribute);
            if (n == 0) continue;
            stringBuilder.append(String.format("\n%-14s %3d", attribute.name, n));
            bl2 = true;
        }
        if (!bl2) {
            stringBuilder.append("\n-");
        }
    }

    public static void printCharacterShort(StringBuilder stringBuilder, ClassCreature classCreature) {
        StaticView.printStats(stringBuilder, classCreature);
        stringBuilder.append("\n\n");
        StaticView.printAbilities(stringBuilder, classCreature, true);
        stringBuilder.append("\n\n");
        StaticView.printAttributes(stringBuilder, classCreature, true);
        if (classCreature.combatActions != null) {
            stringBuilder.append("\n\n");
            StaticView.printCombatActions(stringBuilder, classCreature);
        }
    }

    public static void printCharacter(StringBuilder stringBuilder, ClassCreature classCreature) {
        StaticView.printStats(stringBuilder, classCreature);
        if (classCreature.equipment != null) {
            stringBuilder.append("\n\nEQUIPPED\n");
            stringBuilder.append(classCreature.equipment.getName());
        }
        stringBuilder.append("\n\n");
        StaticView.printAbilities(stringBuilder, classCreature, true);
        stringBuilder.append("\n\n");
        StaticView.printAttributes(stringBuilder, classCreature, true);
        stringBuilder.append("\n\n");
        StaticView.printMods(stringBuilder, classCreature, true);
        if (classCreature.hasTraits()) {
            stringBuilder.append("\n\n");
            StaticView.printTraits(stringBuilder, classCreature);
        }
        if (classCreature.combatActions != null) {
            stringBuilder.append("\n\n");
            StaticView.printCombatActions(stringBuilder, classCreature);
        }
        if (classCreature.hasConditions()) {
            stringBuilder.append("\n\n");
            StaticView.printConditions(stringBuilder, classCreature);
        }
        if (classCreature.hasImmunities()) {
            stringBuilder.append("\n\n");
            StaticView.printImmunities(stringBuilder, classCreature);
        }
        stringBuilder.append("\n\n");
        StaticView.printDamageReduction(stringBuilder, classCreature);
        stringBuilder.append("\n\n");
        StaticView.printDamageResistance(stringBuilder, classCreature);
    }

    public static void printCheck(StringBuilder stringBuilder, ICheck iCheck) {
        if (iCheck instanceof AbilityCheck) {
            AbilityCheck abilityCheck = (AbilityCheck)iCheck;
            stringBuilder.append(abilityCheck.dc);
            stringBuilder.append(" ");
            stringBuilder.append(abilityCheck.ability.name);
        } else if (iCheck instanceof TraitCheck) {
            TraitCheck traitCheck = (TraitCheck)iCheck;
            stringBuilder.append(traitCheck.trait.name);
        } else if (iCheck instanceof LearnCombatActionCheck) {
            LearnCombatActionCheck learnCombatActionCheck = (LearnCombatActionCheck)iCheck;
            for (ICheck iCheck2 : learnCombatActionCheck.combatAction.getRequirements()) {
                stringBuilder.append("\n");
                StaticView.printCheck(stringBuilder, iCheck2);
            }
        } else {
            stringBuilder.append("<").append(iCheck.getClass().getSimpleName()).append(">");
        }
    }

    public static void printCombatActionFor(StringBuilder stringBuilder, CombatAction combatAction, ClassCreature classCreature, boolean bl) {
        if (combatAction == null) {
            return;
        }
        int n = combatAction.getActionPointCost();
        float f = combatAction.getHitChance();
        float f2 = combatAction.getCritChance();
        if (combatAction._data.base != null) {
            int n2 = classCreature.calcAbilityScore(Ability.valueOf(combatAction._data.base));
            Object object = StaticCombat.COMBAT_LEVELS.get(combatAction._data.base, n2);
            f += ((CombatLevelsFactory.CombatLevels.Entry)object).hitChance;
            f2 += ((CombatLevelsFactory.CombatLevels.Entry)object).critChance;
        }
        stringBuilder.append(combatAction.getName());
        stringBuilder.append("\nAP ").append(n);
        stringBuilder.append("\nHit ").append((int)(f * 100.0f)).append("%");
        stringBuilder.append("\nCrit ").append((int)(f2 * 100.0f)).append("% ").append(combatAction.getCritMultiplier()).append("x");
        stringBuilder.append("\n");
        stringBuilder.append("\n").append((Object)combatAction.getTarget());
        stringBuilder.append("\n").append((Object)combatAction.getRangeFrom());
        if (combatAction.getRangeFrom() != combatAction.getRangeTo()) {
            stringBuilder.append("-").append((Object)combatAction.getRangeTo());
        }
        stringBuilder.append("\n");
        StaticAction.printActions(stringBuilder, combatAction.getActions());
        stringBuilder.append("\n\n");
        if (combatAction.getDescription() != null) {
            stringBuilder.append(combatAction.getDescription());
        } else {
            stringBuilder.append("<description>");
        }
        if (bl && combatAction.getRequirements() != null) {
            stringBuilder.append("\n\nREQUIREMENT");
            for (Object object : combatAction.getRequirements()) {
                stringBuilder.append("\n");
                StaticView.printCheck(stringBuilder, (ICheck)object);
            }
        }
    }

    public static void printCombatAction(StringBuilder stringBuilder, CombatAction combatAction, boolean bl) {
        if (combatAction == null) {
            return;
        }
        stringBuilder.append(combatAction.getName());
        stringBuilder.append("\nAP ").append(combatAction.getActionPointCost());
        stringBuilder.append("\nHit ").append((int)(combatAction.getHitChance() * 100.0f)).append("%");
        stringBuilder.append("\nCrit ").append((int)(combatAction.getCritChance() * 100.0f)).append("% ").append(combatAction.getCritMultiplier()).append("x");
        stringBuilder.append("\n");
        stringBuilder.append("\n").append((Object)combatAction.getTarget());
        stringBuilder.append("\n").append((Object)combatAction.getRangeFrom());
        if (combatAction.getRangeFrom() != combatAction.getRangeTo()) {
            stringBuilder.append("-").append((Object)combatAction.getRangeTo());
        }
        stringBuilder.append("\n");
        StaticAction.printActions(stringBuilder, combatAction.getActions());
        stringBuilder.append("\n\n");
        if (combatAction.getDescription() != null) {
            stringBuilder.append(combatAction.getDescription());
        } else {
            stringBuilder.append("<description>");
        }
        if (bl && combatAction.getRequirements() != null) {
            stringBuilder.append("\n\nREQUIREMENT");
            for (ICheck iCheck : combatAction.getRequirements()) {
                stringBuilder.append("\n");
                StaticView.printCheck(stringBuilder, iCheck);
            }
        }
    }

    public static void printCombatActions(StringBuilder stringBuilder, ClassCreature classCreature) {
        stringBuilder.append("COMBAT ACTIONS");
        if (classCreature.combatActions == null || classCreature.combatActions.isEmpty()) {
            stringBuilder.append("\n-");
        } else {
            for (CombatAction combatAction : classCreature.combatActions) {
                stringBuilder.append("\n").append(combatAction.getName());
            }
        }
    }

    public static void printCondition(Condition.Data data, StringBuilder stringBuilder) {
        stringBuilder.append(data.name);
        stringBuilder.append("\nCannotDefend ");
        stringBuilder.append(data.cannotDefend);
        stringBuilder.append("\nCannotRun ");
        stringBuilder.append(data.cannotRunAway);
        stringBuilder.append("\nRemoveOnDamage ");
        stringBuilder.append(data.removeOnDamage);
        stringBuilder.append("\nHit Chance (attack) ");
        stringBuilder.append(data.modifiers.modHitChanceAttacker);
        stringBuilder.append("\nHit Chance (defense) ");
        stringBuilder.append(data.modifiers.modHitChanceDefender);
        stringBuilder.append("\n\n");
        stringBuilder.append(data.description);
    }

    public static void printConditions(StringBuilder stringBuilder, ClassCreature classCreature) {
        stringBuilder.append("CONDITIONS");
        if (!classCreature.hasConditions()) {
            stringBuilder.append("\n-");
        } else {
            for (Condition condition : classCreature.getConditions()) {
                stringBuilder.append("\n").append(condition.getName());
            }
        }
    }

    public static void printDamageReduction(StringBuilder stringBuilder, ClassCreature classCreature) {
        stringBuilder.append("REDUCTION");
        int n = 0;
        for (DamageType damageType : DamageType.values()) {
            Damage damage = new Damage(Component.HP, damageType);
            int n2 = classCreature.calcDamageReduction(damage);
            if (n2 == 0) continue;
            stringBuilder.append(String.format("\n%-14s %+3d", damage.type.name, n2));
            ++n;
        }
        if (n == 0) {
            stringBuilder.append("\n-");
        }
    }

    public static void printDamageReduction(StringBuilder stringBuilder, DamageReductions damageReductions) {
        stringBuilder.append("REDUCTION");
        if (damageReductions == null || damageReductions.isEmpty()) {
            stringBuilder.append("\n-");
            return;
        }
        for (Map.Entry entry : damageReductions.entrySet()) {
            Damage damage = (Damage)entry.getKey();
            int n = (Integer)entry.getValue();
            if (n == 0) continue;
            stringBuilder.append(String.format("\n%-14s %+3d", damage.type.name, n));
        }
    }

    public static void printDamageResistance(StringBuilder stringBuilder, ClassCreature classCreature) {
        stringBuilder.append("RESISTANCE       %");
        int n = 0;
        for (DamageType damageType : DamageType.values()) {
            Damage damage = new Damage(Component.HP, damageType);
            float f = classCreature.calcDamageResistance(damage);
            if (f == 0.0f) continue;
            int n2 = (int)(f * 100.0f);
            stringBuilder.append(String.format("\n%-14s %+3d", damage.type.name, n2));
            ++n;
        }
        if (n == 0) {
            stringBuilder.append("\n-");
        }
    }

    public static void printDamageResistance(StringBuilder stringBuilder, DamageResistances damageResistances) {
        stringBuilder.append("RESISTANCE");
        if (damageResistances == null || damageResistances.isEmpty()) {
            stringBuilder.append("\n-");
            return;
        }
        for (Map.Entry entry : damageResistances.entrySet()) {
            Damage damage = (Damage)entry.getKey();
            float f = ((Float)entry.getValue()).floatValue();
            if (f == 0.0f) continue;
            stringBuilder.append(String.format("\n%-16s %.1f", damage.type.name, Float.valueOf(f)));
        }
    }

    public static void printDiff(StringBuilder stringBuilder, ClassCreature classCreature, Item item, Item item2) {
        int n;
        int n2;
        stringBuilder.append("ABILITIES");
        for (Ability object : Ability.values()) {
            int n3 = classCreature.getAbilityScore(object) + (item != null ? item.getAbilityScore(object) : 0);
            n2 = classCreature.getAbilityScore(object) + (item2 != null ? item2.getAbilityScore(object) : 0);
            n = n2 - n3;
            if (n == 0) continue;
            stringBuilder.append(String.format("\n%s %+d %d>%d", object.name, n, n3, n2));
        }
        stringBuilder.append("\n\nREDUCTION");
        for (DamageType damageType : DamageType.values()) {
            Damage damage = new Damage(Component.HP, damageType);
            n2 = classCreature.getDamageReduction(damage) + (item != null ? item.getDamageReduction(damage) : 0);
            n = classCreature.getDamageReduction(damage) + (item2 != null ? item2.getDamageReduction(damage) : 0);
            int n4 = n - n2;
            if (n4 == 0) continue;
            stringBuilder.append(String.format("\n%s %+d %d>%d", damageType.name, n4, n2, n));
        }
    }

    public static void printDiff(StringBuilder stringBuilder, Item item, Item item2) {
        int n;
        int n2;
        stringBuilder.append("ABILITIES");
        for (Ability object : Ability.values()) {
            int n3;
            n2 = item2 != null ? item2.getAbilityScore(object) : 0;
            n = n2 - (n3 = item != null ? item.getAbilityScore(object) : 0);
            if (n == 0) continue;
            stringBuilder.append(String.format("\n%s %+d %d>%d ", object.name, n3, n2, n));
        }
        stringBuilder.append("\n\nREDUCTION");
        for (DamageType damageType : DamageType.values()) {
            Damage damage = new Damage(Component.HP, damageType);
            n = item2 != null ? item2.getDamageReduction(damage) : 0;
            int n4 = n - (n2 = item != null ? item.getDamageReduction(damage) : 0);
            if (n4 == 0) continue;
            stringBuilder.append(String.format("\n%-14s %3d>%-3d %+d", damageType.name, n2, n, n4));
        }
    }

    public static void printImmunities(StringBuilder stringBuilder, ClassCreature classCreature) {
        stringBuilder.append("IMMUNITIES");
        ConditionImmunities conditionImmunities = classCreature.collectImmunities();
        if (conditionImmunities.isEmpty()) {
            stringBuilder.append("\n-");
        } else {
            for (ConditionImmunity conditionImmunity : conditionImmunities) {
                stringBuilder.append("\n").append(conditionImmunity.conditionId);
            }
        }
    }

    public static void printImmunities(StringBuilder stringBuilder, ConditionImmunities conditionImmunities) {
        stringBuilder.append("IMMUNITIES");
        if (conditionImmunities == null || conditionImmunities.isEmpty()) {
            stringBuilder.append("\n-");
        } else {
            for (ConditionImmunity conditionImmunity : conditionImmunities) {
                stringBuilder.append("\n").append(conditionImmunity.conditionId);
            }
        }
    }

    public static void printItem(StringBuilder stringBuilder, Item item) {
        Modifiers modifiers = item._data.modifiers;
        stringBuilder.append(item.getName());
        stringBuilder.append("\n\n");
        if (item.getDescription() != null && !item.getDescription().isEmpty()) {
            stringBuilder.append(item.getDescription());
        } else {
            stringBuilder.append("<description>");
        }
        stringBuilder.append("\n\n");
        StaticView.printModifiers(stringBuilder, modifiers);
    }

    public static void printRequirements(StringBuilder stringBuilder, Checks checks) {
        if (checks == null) {
            return;
        }
        stringBuilder.append("REQUIREMENTS");
        for (ICheck iCheck : checks) {
            stringBuilder.append("\n");
            StaticView.printCheck(stringBuilder, iCheck);
        }
    }

    public static void printModifiers(StringBuilder stringBuilder, Modifiers modifiers) {
        if (modifiers == null) {
            return;
        }
        stringBuilder.append("MODIFIERS");
        if (modifiers.modMaxHitPoints != 0) {
            stringBuilder.append(String.format("\nMax HP %+d", modifiers.modMaxHitPoints));
        }
        if (modifiers.modMaxActionPoints != 0) {
            stringBuilder.append(String.format("\nMax AP %+d", modifiers.modMaxActionPoints));
        }
        if (modifiers.modVim != 0) {
            stringBuilder.append(String.format("\nVIM %+d", modifiers.modVim));
        }
        if (modifiers.modCritChance != 0.0f) {
            stringBuilder.append(String.format("\n%s %d", "Crit%", StaticView.percent(modifiers.modCritChance)));
        }
        if (modifiers.modHitChanceAttacker != 0.0f) {
            stringBuilder.append(String.format("\n%s %d", "Attack%", StaticView.percent(modifiers.modHitChanceAttacker)));
        }
        if (modifiers.modHitChanceDefender != 0.0f) {
            stringBuilder.append(String.format("\n%s %d", "Defense%", StaticView.percent(-modifiers.modHitChanceDefender)));
        }
        if (modifiers.modImmuneToCrits) {
            stringBuilder.append("\nImmune to crits");
        }
        if (modifiers.modAbilities != null) {
            stringBuilder.append("\n\n");
            StaticView.printAbilities(stringBuilder, modifiers.modAbilities, true, true);
        }
        if (modifiers.modAttributes != null) {
            stringBuilder.append("\n\n");
            StaticView.printAttributes(stringBuilder, modifiers.modAttributes, true, true);
        }
        if (modifiers.modImmunities != null) {
            stringBuilder.append("\n\n");
            StaticView.printImmunities(stringBuilder, modifiers.modImmunities);
        }
        if (modifiers.modDamageReductions != null) {
            stringBuilder.append("\n\n");
            StaticView.printDamageReduction(stringBuilder, modifiers.modDamageReductions);
        }
        if (modifiers.modDamageResistances != null) {
            stringBuilder.append("\n\n");
            StaticView.printDamageResistance(stringBuilder, modifiers.modDamageResistances);
        }
    }

    public static void printMods(StringBuilder stringBuilder, ClassCreature classCreature, boolean bl) {
        if (classCreature.mods != null) {
            if (bl) {
                stringBuilder.append("MODS");
            }
            for (Slot slot : classCreature.mods.values()) {
                if (slot.mod == null) continue;
                stringBuilder.append("\n").append(slot.mod.getName());
            }
        }
    }

    public static void printParty(Party party, StringBuilder stringBuilder) {
        for (ClassCreature classCreature : party.getMembers()) {
            stringBuilder.append(classCreature.name);
            stringBuilder.append("\n");
        }
    }

    public static void printParty(StringBuilder stringBuilder, Party party) {
        StaticView.printPartyHeader(stringBuilder);
        for (ClassCreature classCreature : party.getMembers()) {
            StaticView.printPartyRow(stringBuilder, classCreature);
            if (party.isEncumbered()) {
                stringBuilder.append("ENCUMBERED");
            } else {
                StaticView.printPartyRowCond(stringBuilder, classCreature, conditionCycle);
            }
            stringBuilder.append("\n");
        }
    }

    public static void printPartyHeader(StringBuilder stringBuilder) {
        stringBuilder.append("CHARACTER NAME  JOB ACTS HITS STATUS\n");
    }

    public static void printPartyRow(StringBuilder stringBuilder, ClassCreature classCreature) {
        stringBuilder.append(String.format("%-14s  %s %4d %4d ", classCreature.name, classCreature.job != null ? classCreature.job.subSequence(0, 3) : "   ", classCreature.actionPoints, classCreature.hitPoints));
    }

    public static void printPartyRowCond(StringBuilder stringBuilder, ClassCreature classCreature, int n) {
        if (classCreature.isDead()) {
            stringBuilder.append("Dead");
        } else if (classCreature.hasConditions()) {
            List<Condition> list = classCreature.getConditions();
            int n2 = n % list.size();
            stringBuilder.append(list.get(n2).getName());
        } else {
            stringBuilder.append(String.format("%4s", classCreature.calcMaxHitPoints()));
        }
    }

    public static void printRecipe(StringBuilder stringBuilder, Recipe recipe, float f) {
        int n;
        stringBuilder.append("DURATION\n");
        stringBuilder.append(Duration.toString((long)((float)recipe.duration * f)));
        stringBuilder.append("\n\nINPUT");
        for (ItemGroup object : recipe.input) {
            n = RPG.getInstance().party.inventory.count(object.getId());
            stringBuilder.append("\n");
            stringBuilder.append(object.getName());
            stringBuilder.append(" (");
            stringBuilder.append(n);
            stringBuilder.append("/");
            stringBuilder.append(object.size);
            stringBuilder.append(")");
        }
        stringBuilder.append("\n\nOUTPUT");
        for (ItemGroup itemGroup : recipe.output) {
            n = RPG.getInstance().party.inventory.count(itemGroup.getId());
            stringBuilder.append("\n");
            stringBuilder.append(itemGroup.getName());
            stringBuilder.append(" (");
            stringBuilder.append(n);
            stringBuilder.append("/");
            stringBuilder.append(itemGroup.size);
            stringBuilder.append(")");
        }
        if (recipe.requirements != null) {
            stringBuilder.append("\n\nREQUIREMENTS");
            for (ICheck iCheck : recipe.requirements) {
                stringBuilder.append("\n");
                StaticView.printCheck(stringBuilder, iCheck);
            }
        }
    }

    public static void printSlotMods(StringBuilder stringBuilder, ClassCreature classCreature) {
        Slot[] slotArray = classCreature.getSlots();
        stringBuilder.append("MODS");
        if (slotArray == null) {
            stringBuilder.append("\n-");
        } else {
            for (int i = 0; i < slotArray.length; ++i) {
                Slot slot = slotArray[i];
                String string = String.format("%-4s %s", slot.getName(), slot.mod != null ? slot.mod.getName() : "-");
                stringBuilder.append("\n").append(string);
            }
        }
    }

    public static void printSlots(StringBuilder stringBuilder, Slots slots) {
        Slot[] slotArray;
        if (slots == null) {
            return;
        }
        for (Slot slot : slotArray = slots.values()) {
            String string = String.format("%-4s|%s\n", slot.getName(), slot.mod != null ? slot.mod.getName() : "");
            stringBuilder.append(string);
        }
    }

    public static void printStats(StringBuilder stringBuilder, ClassCreature classCreature) {
        float f = classCreature.calcVimRatio();
        int n = (int)(f * 100.0f);
        stringBuilder.append("HP ");
        stringBuilder.append(classCreature.hitPoints);
        stringBuilder.append("/");
        stringBuilder.append(classCreature.calcMaxHitPoints());
        stringBuilder.append("\nAP ");
        stringBuilder.append(classCreature.actionPoints);
        stringBuilder.append("/");
        stringBuilder.append(classCreature.calcMaxActionPoints());
        stringBuilder.append("\nVIM ");
        stringBuilder.append(classCreature.calcVim());
        stringBuilder.append(" ");
        stringBuilder.append(n);
        stringBuilder.append("%");
    }

    public static void printTraits(StringBuilder stringBuilder, ClassCreature classCreature) {
        stringBuilder.append("TRAITS");
        if (!classCreature.hasTraits()) {
            stringBuilder.append("\n-");
        } else {
            for (Trait trait : Trait.values()) {
                if (!classCreature.hasTrait(trait)) continue;
                stringBuilder.append("\n").append(trait.name);
            }
        }
    }
}

