/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.opengl;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;

public class GLByteBuffer {
    private static final int MAX_BUFFER_SIZE = 1000000000;
    private ByteBuffer bb = null;

    public GLByteBuffer(int n) {
        this.bb = BufferUtils.createByteBuffer(n);
    }

    public void capacity(int n) {
        if (n > this.bb.capacity() && n <= 1000000000) {
            this.bb.clear();
            this.bb = null;
            this.bb = BufferUtils.createByteBuffer(n);
        }
    }

    public void clear() {
        this.bb.clear();
    }

    public void color3f(float f, float f2, float f3) {
        this.bb.putFloat(f);
        this.bb.putFloat(f2);
        this.bb.putFloat(f3);
    }

    public void color4f(float f, float f2, float f3, float f4) {
        this.bb.putFloat(f);
        this.bb.putFloat(f2);
        this.bb.putFloat(f3);
        this.bb.putFloat(f4);
    }

    public ByteBuffer data() {
        return this.bb;
    }

    public void flip() {
        this.bb.flip();
    }

    public int limit() {
        return this.bb.limit();
    }

    public int position() {
        return this.bb.position();
    }

    public void put(GLByteBuffer gLByteBuffer) {
        this.bb.put(gLByteBuffer.bb);
    }

    public void putInt(int n) {
        this.bb.putInt(n);
    }

    public void rewind() {
        this.bb.rewind();
    }

    public void texcoord2f(float f, float f2) {
        this.bb.putFloat(f);
        this.bb.putFloat(f2);
    }

    public void vertex2f(float f, float f2) {
        this.bb.putFloat(f);
        this.bb.putFloat(f2);
    }

    public void vertex3f(float f, float f2, float f3) {
        this.bb.putFloat(f);
        this.bb.putFloat(f2);
        this.bb.putFloat(f3);
    }

    public void vertex4f(float f, float f2, float f3, float f4) {
        this.bb.putFloat(f);
        this.bb.putFloat(f2);
        this.bb.putFloat(f3);
        this.bb.putFloat(f4);
    }
}

