/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.opengl;

import de.slashbinbash.opengl.AppConfig;
import de.slashbinbash.opengl.FPS;
import de.slashbinbash.opengl.IApp;
import de.slashbinbash.opengl.Joystick;
import de.slashbinbash.opengl.JoystickCallback;
import de.slashbinbash.opengl.JoystickEvent;
import de.slashbinbash.opengl.KeyboardEvent;
import de.slashbinbash.opengl.MouseEvent;
import de.slashbinbash.opengl.Sync;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import org.lwjgl.Version;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWKeyCallbackI;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.glfw.GLFWWindowSizeCallback;
import org.lwjgl.glfw.GLFWWindowSizeCallbackI;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.MemoryStack;

public class LWJGL3 {
    private static long window;

    public static long getWindow() {
        return window;
    }

    public static void runApp(final IApp iApp) {
        final AppConfig appConfig = iApp.getConfig();
        GLFWErrorCallback.createPrint((PrintStream)System.err).set();
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)139266, (int)3);
        GLFW.glfwWindowHint((int)139267, (int)3);
        GLFW.glfwWindowHint((int)139272, (int)204801);
        GLFW.glfwWindowHint((int)131076, (int)0);
        GLFW.glfwWindowHint((int)135184, (int)1);
        GLFW.glfwWindowHint((int)131075, (int)(appConfig.resizable ? 1 : 0));
        window = GLFW.glfwCreateWindow((int)appConfig.width, (int)appConfig.height, (CharSequence)appConfig.title, (long)0L, (long)0L);
        if (window == 0L) {
            throw new RuntimeException("Failed to create the GLFW window");
        }
        if (appConfig.grabMouse) {
            GLFW.glfwSetInputMode((long)window, (int)208897, (int)212995);
        }
        final MouseEvent mouseEvent = new MouseEvent();
        final KeyboardEvent keyboardEvent = new KeyboardEvent();
        final JoystickEvent joystickEvent = new JoystickEvent();
        GLFW.glfwSetKeyCallback((long)window, (GLFWKeyCallbackI)new GLFWKeyCallback(){

            public void invoke(long l, int n, int n2, int n3, int n4) {
                if (n3 == 2 && appConfig.ignoreKeyRepeat) {
                    return;
                }
                keyboardEvent.window = l;
                keyboardEvent.key = n;
                keyboardEvent.scancode = n2;
                keyboardEvent.action = n3;
                keyboardEvent.mods = n4;
                keyboardEvent.down = n3 == 1;
                keyboardEvent.consumed = false;
                iApp.handleKeyboardEvent(keyboardEvent);
            }
        });
        GLFW.glfwSetCursorPosCallback((long)window, (GLFWCursorPosCallbackI)new GLFWCursorPosCallback(){
            public double lastX = Double.NaN;
            public double lastY = Double.NaN;

            public void invoke(long l, double d, double d2) {
                if (Double.isNaN(this.lastX) && Double.isNaN(this.lastY)) {
                    this.lastX = d;
                    this.lastY = d2;
                    return;
                }
                mouseEvent.window = l;
                mouseEvent.button = -1;
                mouseEvent.action = -1;
                mouseEvent.mods = -1;
                mouseEvent.x = (float)d;
                mouseEvent.y = (float)d2;
                mouseEvent.dx = (float)(d - this.lastX);
                mouseEvent.dy = (float)(d2 - this.lastY);
                mouseEvent.down = false;
                this.lastX = d;
                this.lastY = d2;
                iApp.handleMouseEvent(mouseEvent);
            }
        });
        GLFW.glfwSetMouseButtonCallback((long)window, (GLFWMouseButtonCallbackI)new GLFWMouseButtonCallback(){

            public void invoke(long l, int n, int n2, int n3) {
                mouseEvent.window = l;
                mouseEvent.button = n;
                mouseEvent.action = n2;
                mouseEvent.mods = n3;
                mouseEvent.dx = 0.0f;
                mouseEvent.dy = 0.0f;
                mouseEvent.down = n2 == 1;
                iApp.handleMouseEvent(mouseEvent);
            }
        });
        Joystick.init();
        Joystick.setCallback(new JoystickCallback(){

            @Override
            public void invoke(int n, int n2, int n3) {
                joystickEvent.jid = n;
                joystickEvent.button = n2;
                joystickEvent.down = n3 == 1;
                iApp.handleJoystickEvent(joystickEvent);
            }
        });
        if (appConfig.resizable) {
            GLFW.glfwSetWindowSizeCallback((long)window, (GLFWWindowSizeCallbackI)new GLFWWindowSizeCallback(){

                public void invoke(long l, int n, int n2) {
                    iApp.handleResizeEvent(n, n2);
                }
            });
        }
        try (Object object = MemoryStack.stackPush();){
            IntBuffer intBuffer = ((MemoryStack)object).mallocInt(1);
            IntBuffer intBuffer2 = ((MemoryStack)object).mallocInt(1);
            GLFW.glfwGetWindowSize((long)window, (IntBuffer)intBuffer, (IntBuffer)intBuffer2);
            GLFWVidMode gLFWVidMode = GLFW.glfwGetVideoMode((long)GLFW.glfwGetPrimaryMonitor());
            GLFW.glfwSetWindowPos((long)window, (int)((gLFWVidMode.width() - intBuffer.get(0)) / 2), (int)((gLFWVidMode.height() - intBuffer2.get(0)) / 2));
        }
        GLFW.glfwMakeContextCurrent((long)window);
        GLFW.glfwSwapInterval((int)(appConfig.vsync ? 1 : 0));
        GLFW.glfwShowWindow((long)window);
        GL.createCapabilities();
        System.out.println("LWJGL " + Version.getVersion());
        iApp.init();
        object = new FPS();
        Sync.init();
        while (!GLFW.glfwWindowShouldClose((long)window)) {
            GLFW.glfwPollEvents();
            Joystick.update();
            iApp.tick();
            iApp.draw();
            iApp.drawFPS(((FPS)object).fps);
            GLFW.glfwSwapBuffers((long)window);
            ((FPS)object).update();
            Sync.sync3(60);
        }
        iApp.exit();
        Callbacks.glfwFreeCallbacks((long)window);
        GLFW.glfwDestroyWindow((long)window);
        GLFW.glfwTerminate();
        GLFW.glfwSetErrorCallback(null).free();
    }

    public static void createScreenshot(String string) {
        BufferedImage bufferedImage = LWJGL3.createScreenshot();
        int n = 320;
        int n2 = 180;
        Image image = bufferedImage.getScaledInstance(n, n2, 4);
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", new File(string + ".png"));
            ImageIO.write((RenderedImage)bufferedImage2, "png", new File(string + "_thumb.png"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static BufferedImage createScreenshot() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        GLFW.glfwGetWindowSize((long)window, (int[])nArray, (int[])nArray2);
        int n = nArray[0];
        int n2 = nArray2[0];
        int[] nArray3 = new int[n * n2];
        GL11.glReadPixels((int)0, (int)0, (int)n, (int)n2, (int)6408, (int)5121, (int[])nArray3);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = (n2 - i - 1) * n + j;
                int n4 = nArray3[n3];
                int n5 = n4 & 0xFF;
                int n6 = (n4 & 0xFF00) >> 8;
                int n7 = (n4 & 0xFF0000) >> 16;
                int n8 = n5 << 16 | n6 << 8 | n7;
                bufferedImage.setRGB(j, i, n8);
            }
        }
        return bufferedImage;
    }
}

