/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.opengl;

import de.slashbinbash.opengl.Image;
import de.slashbinbash.opengl.Texture;
import de.slashbinbash.opengl.TextureBuilder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

public class TextureFactory {
    public static Texture createTexture(BufferedImage bufferedImage) {
        return TextureBuilder.from(bufferedImage).build();
    }

    public static Texture createTexture(BufferedImage bufferedImage, int n) {
        return TextureBuilder.from(bufferedImage).setWrap(n, n).build();
    }

    public static Texture createTexture(File file) throws IOException {
        return TextureBuilder.from(file).build();
    }

    public static Texture createTexture(File file, int n) throws IOException {
        return TextureBuilder.from(file).setWrap(n, n).build();
    }

    public static Texture createTexture(Image image) {
        return TextureBuilder.from(image).build();
    }

    public static Texture createTexture(Image image, int n) {
        return TextureBuilder.from(image).setWrap(n, n).build();
    }

    public static Texture createTexture(int n, int n2, int n3) {
        return new TextureBuilder(n, n2, n3, null).build();
    }

    public static void deleteTexture(Texture texture) {
        TextureBuilder.deleteTexture(texture);
    }

    public static void updateTexture(Texture texture, Image image) {
        TextureBuilder.updateTexture(texture, image);
    }

    public static void updateTexture(Texture texture, BufferedImage bufferedImage) {
        TextureBuilder.updateTexture(texture, bufferedImage);
    }
}

