/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.opengl.renderer;

import de.slashbinbash.opengl.Font;
import de.slashbinbash.opengl.GLByteBuffer;
import de.slashbinbash.opengl.Shader;
import de.slashbinbash.opengl.ShaderFactory;
import de.slashbinbash.opengl.Texture;
import de.slashbinbash.opengl.TextureFactory;
import de.slashbinbash.opengl.math.Math3D;
import de.slashbinbash.opengl.math.Rect2f;
import de.slashbinbash.util.Resource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class Draw2D {
    private static final int NUM_FLOATS_PRIM = 6;
    private static final int NUM_FLOATS_TEX = 8;
    private static final int DRAW_POINT = 1;
    public static final int DRAW_LINE = 2;
    private static final int DRAW_RECTANGLE = 3;
    private static final int DRAW_TEXTURE = 4;
    private static final int DRAW_STRING = 5;
    private static final int FILL_RECTANGLE = 6;
    public static final int FILL_TRIANGLE = 7;
    private static final int DRAW_POLYGON = 8;
    public static final int BLEND = 1;
    private static final int DEPTH = 2;
    private float[] color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private Texture tex = null;
    private GLByteBuffer bb = new GLByteBuffer(0);
    private int bufferSize;
    private int vbo = 0;
    private int primVao = 0;
    private Shader primShader = null;
    private int texVao = 0;
    private Shader texShader = null;
    private Matrix4f projectionMatrix = new Matrix4f();
    private Matrix4f modelViewMatrix = new Matrix4f();
    private Matrix4f[] matrixStack = new Matrix4f[25];
    private int matrixStackPtr = -1;
    private Vector3f v = new Vector3f();
    private Font font = null;
    private Texture fontTexture = null;
    private HashMap<String, Texture> fontTextures = new HashMap();
    private Vector2f origin = new Vector2f(0.0f, 0.0f);
    private Rect2f srcFontRect = new Rect2f(0.0f, 0.0f, 0.0f, 0.0f);
    private Rect2f dstFontRect = new Rect2f(0.0f, 0.0f, 0.0f, 0.0f);
    private boolean buffering = false;
    private int bufferType = 0;

    public Draw2D() {
        try {
            this.primShader = ShaderFactory.createShader(new Resource("shader/VVCCCC.vert").readString(), new Resource("shader/VVCCCC.frag").readString());
            this.texShader = ShaderFactory.createShader(new Resource("shader/VVCCCCTT.vert").readString(), new Resource("shader/VVCCCCTT.frag").readString());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.vbo = GL15.glGenBuffers();
        this.primVao = GL30.glGenVertexArrays();
        GL30.glBindVertexArray((int)this.primVao);
        GL15.glBindBuffer((int)34962, (int)this.vbo);
        int n = 24;
        GL20.glVertexAttribPointer((int)0, (int)2, (int)5126, (boolean)false, (int)n, (long)0L);
        GL20.glVertexAttribPointer((int)1, (int)4, (int)5126, (boolean)false, (int)n, (long)8L);
        GL15.glBindBuffer((int)34962, (int)0);
        GL30.glBindVertexArray((int)0);
        this.texVao = GL30.glGenVertexArrays();
        GL30.glBindVertexArray((int)this.texVao);
        GL15.glBindBuffer((int)34962, (int)this.vbo);
        n = 32;
        GL20.glVertexAttribPointer((int)0, (int)2, (int)5126, (boolean)false, (int)n, (long)0L);
        GL20.glVertexAttribPointer((int)1, (int)4, (int)5126, (boolean)false, (int)n, (long)8L);
        GL20.glVertexAttribPointer((int)2, (int)2, (int)5126, (boolean)false, (int)n, (long)24L);
        GL15.glBindBuffer((int)34962, (int)0);
        GL30.glBindVertexArray((int)0);
    }

    public void begin() {
        if (!this.buffering) {
            this.buffering = true;
            this.bb.clear();
        }
    }

    private void bufferBytes(GLByteBuffer gLByteBuffer, int n) {
        assert (this.buffering);
        this.bb.put(gLByteBuffer);
        this.bufferType = n;
    }

    private void bufferChar(char c) {
        if (c == '\n') {
            this.dstFontRect.x = this.origin.x;
            this.dstFontRect.y += this.dstFontRect.height;
            return;
        }
        this.font.get(c, this.srcFontRect);
        this.bufferTexture(this.fontTexture, (int)this.srcFontRect.x, (int)this.srcFontRect.y, (int)this.srcFontRect.width, (int)this.srcFontRect.height, this.dstFontRect.x, this.dstFontRect.y, this.dstFontRect.width, this.dstFontRect.height);
        this.dstFontRect.x += this.dstFontRect.width;
    }

    private void bufferLine(float f, float f2, float f3, float f4) {
        this.bb.vertex2f(f, f2);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
        this.bb.vertex2f(f3, f4);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
    }

    private void bufferLinesRect(float f, float f2, float f3, float f4) {
        this.bb.vertex2f(f, f2);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
        this.bb.vertex2f(f, f2 + f4);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
        this.bb.vertex2f(f, f2 + f4);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
        this.bb.vertex2f(f + f3, f2 + f4);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
        this.bb.vertex2f(f + f3, f2 + f4);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
        this.bb.vertex2f(f + f3, f2);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
        this.bb.vertex2f(f + f3, f2);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
        this.bb.vertex2f(f, f2);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
    }

    private void bufferPoint(float f, float f2) {
        this.bb.vertex2f(f, f2);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
    }

    private void bufferString(char[] cArray, int n, int n2) {
        assert (n + n2 <= cArray.length);
        for (int i = 0; i < n2; ++i) {
            this.bufferChar(cArray[n + i]);
        }
    }

    private void bufferString(String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.bufferChar(string.charAt(i));
        }
    }

    private void bufferTexture(Texture texture, int n, int n2, int n3, int n4, float f, float f2, float f3, float f4) {
        this.tex = texture;
        float f5 = (float)n / (float)texture.width;
        float f6 = (float)n2 / (float)texture.height;
        float f7 = (float)(n + n3) / (float)texture.width;
        float f8 = (float)(n2 + n4) / (float)texture.height;
        this.bufferTextureUV(f5, f6, f7, f8, f, f2, f3, f4);
    }

    private void bufferTextureUV(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.bb.vertex2f(f5, f6);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
        this.bb.texcoord2f(f, f2);
        this.bb.vertex2f(f5, f6 + f8);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
        this.bb.texcoord2f(f, f4);
        this.bb.vertex2f(f5 + f7, f6);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
        this.bb.texcoord2f(f3, f2);
        this.bb.vertex2f(f5, f6 + f8);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
        this.bb.texcoord2f(f, f4);
        this.bb.vertex2f(f5 + f7, f6 + f8);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
        this.bb.texcoord2f(f3, f4);
        this.bb.vertex2f(f5 + f7, f6);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
        this.bb.texcoord2f(f3, f2);
    }

    private void bufferTriangle(float f, float f2, float f3, float f4, float f5, float f6) {
        this.bb.vertex2f(f, f2);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
        this.bb.vertex2f(f3, f4);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
        this.bb.vertex2f(f5, f6);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
    }

    private void bufferTrianglesRect(float f, float f2, float f3, float f4) {
        this.bb.vertex2f(f, f2);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
        this.bb.vertex2f(f, f2 + f4);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
        this.bb.vertex2f(f + f3, f2);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
        this.bb.vertex2f(f, f2 + f4);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
        this.bb.vertex2f(f + f3, f2 + f4);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
        this.bb.vertex2f(f + f3, f2);
        this.bb.color4f(this.color[0], this.color[1], this.color[2], this.color[3]);
    }

    public void checkCapacity(int n) {
        this.bb.capacity(n);
    }

    public void clear() {
        GL11.glClear((int)16640);
    }

    public void disable(int n) {
        switch (n) {
            case 1: {
                GL11.glDisable((int)3042);
                break;
            }
            case 2: {
                GL11.glDisable((int)2929);
            }
        }
    }

    public void drawLine(float f, float f2, float f3, float f4) {
        this.bufferType = 2;
        if (this.buffering) {
            this.bufferLine(f, f2, f3, f4);
        } else {
            this.begin();
            this.bufferLine(f, f2, f3, f4);
            this.end();
        }
    }

    public void drawPoint(float f, float f2) {
        this.bufferType = 1;
        if (this.buffering) {
            this.bufferPoint(f, f2);
        } else {
            this.begin();
            this.bufferPoint(f, f2);
            this.end();
        }
    }

    public void drawPolygon(float[] fArray, float[] fArray2, int n) {
        this.bufferType = 8;
        if (this.buffering) {
            for (int i = 0; i < n - 1; ++i) {
                this.bufferPoint(fArray[i], fArray2[i]);
                this.bufferPoint(fArray[i + 1], fArray2[i + 1]);
            }
        } else {
            this.begin();
            for (int i = 0; i < n - 1; ++i) {
                this.bufferPoint(fArray[i], fArray2[i]);
                this.bufferPoint(fArray[i + 1], fArray2[i + 1]);
            }
            this.end();
        }
    }

    private void drawPrim(int n) {
        this.drawPrim(n, 0, this.bufferSize / 4 / 6);
    }

    private void drawPrim(int n, int n2, int n3) {
        this.primShader.enable();
        this.primShader.setUniformMatrix4f("ProjectionMatrix", this.projectionMatrix);
        this.primShader.setUniformMatrix4f("ModelViewMatrix", this.modelViewMatrix);
        GL30.glBindVertexArray((int)this.primVao);
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL11.glDrawArrays((int)n, (int)n2, (int)n3);
        GL20.glDisableVertexAttribArray((int)1);
        GL20.glDisableVertexAttribArray((int)0);
        GL30.glBindVertexArray((int)0);
        this.primShader.disable();
    }

    public void drawRect(float f, float f2, float f3, float f4) {
        this.bufferType = 3;
        if (this.buffering) {
            this.bufferLinesRect(f, f2, f3, f4);
        } else {
            this.begin();
            this.bufferLinesRect(f, f2, f3, f4);
            this.end();
        }
    }

    public void drawString(float f, float f2, char c) {
        assert (this.font != null);
        assert (this.fontTexture != null);
        this.bufferType = 5;
        this.origin.set(f, f2);
        this.dstFontRect.x = f;
        this.dstFontRect.y = f2;
        if (this.buffering) {
            this.bufferChar(c);
        } else {
            this.begin();
            this.bufferChar(c);
            this.end();
        }
    }

    public void drawString(float f, float f2, char[] cArray) {
        assert (cArray != null);
        assert (this.font != null);
        assert (this.fontTexture != null);
        this.bufferType = 5;
        this.origin.set(f, f2);
        this.dstFontRect.x = f;
        this.dstFontRect.y = f2;
        if (this.buffering) {
            this.bufferString(cArray, 0, cArray.length);
        } else {
            this.begin();
            this.bufferString(cArray, 0, cArray.length);
            this.end();
        }
    }

    public void drawString(float f, float f2, char[] cArray, int n, int n2) {
        assert (cArray != null);
        assert (this.font != null);
        assert (this.fontTexture != null);
        this.bufferType = 5;
        this.origin.set(f, f2);
        this.dstFontRect.x = f;
        this.dstFontRect.y = f2;
        if (this.buffering) {
            this.bufferString(cArray, n, n2);
        } else {
            this.begin();
            this.bufferString(cArray, n, n2);
            this.end();
        }
    }

    public void drawString(float f, float f2, String string) {
        assert (string != null);
        assert (this.font != null);
        assert (this.fontTexture != null);
        this.bufferType = 5;
        this.origin.set(f, f2);
        this.dstFontRect.x = f;
        this.dstFontRect.y = f2;
        if (this.buffering) {
            this.bufferString(string);
        } else {
            this.begin();
            this.bufferString(string);
            this.end();
        }
    }

    private void drawTex(int n, int n2) {
        this.drawTex(n, n2, 0, this.bufferSize / 4 / 8);
    }

    private void drawTex(int n, int n2, int n3, int n4) {
        this.texShader.enable();
        this.texShader.setUniformMatrix4f("ProjectionMatrix", this.projectionMatrix);
        this.texShader.setUniformMatrix4f("ModelViewMatrix", this.modelViewMatrix);
        GL11.glBindTexture((int)3553, (int)n);
        GL13.glActiveTexture((int)33984);
        GL30.glBindVertexArray((int)this.texVao);
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glEnableVertexAttribArray((int)2);
        GL11.glDrawArrays((int)n2, (int)n3, (int)n4);
        GL20.glDisableVertexAttribArray((int)2);
        GL20.glDisableVertexAttribArray((int)1);
        GL20.glDisableVertexAttribArray((int)0);
        GL30.glBindVertexArray((int)0);
        GL11.glBindTexture((int)3553, (int)0);
        this.texShader.disable();
    }

    public void drawTexture(Texture texture, float f, float f2) {
        this.bufferType = 4;
        if (this.buffering) {
            this.bufferTexture(texture, 0, 0, texture.width, texture.height, f, f2, texture.width, texture.height);
        } else {
            this.begin();
            this.bufferTexture(texture, 0, 0, texture.width, texture.height, f, f2, texture.width, texture.height);
            this.end();
        }
    }

    public void drawTexture(Texture texture, int n, int n2, int n3, int n4, float f, float f2, float f3, float f4) {
        this.bufferType = 4;
        if (this.buffering) {
            this.bufferTexture(texture, n, n2, n3, n4, f, f2, f3, f4);
        } else {
            this.begin();
            this.bufferTexture(texture, n, n2, n3, n4, f, f2, f3, f4);
            this.end();
        }
    }

    public void enable(int n) {
        switch (n) {
            case 1: {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                break;
            }
            case 2: {
                GL11.glEnable((int)2929);
            }
        }
    }

    public void end() {
        assert (this.buffering);
        this.bb.flip();
        this.bufferSize = this.bb.limit();
        if (this.bufferSize > 0) {
            GL15.glBindBuffer((int)34962, (int)this.vbo);
            GL15.glBufferData((int)34962, (ByteBuffer)this.bb.data(), (int)35048);
            GL15.glBindBuffer((int)34962, (int)0);
            switch (this.bufferType) {
                case 1: {
                    this.drawPrim(0);
                    break;
                }
                case 2: {
                    this.drawPrim(1);
                    break;
                }
                case 3: {
                    this.drawPrim(1);
                    break;
                }
                case 8: {
                    this.drawPrim(1);
                    break;
                }
                case 6: {
                    this.drawPrim(4);
                    break;
                }
                case 7: {
                    this.drawPrim(4);
                    break;
                }
                case 4: {
                    if (this.tex.format == 6408) {
                        GL11.glEnable((int)3042);
                        GL11.glBlendFunc((int)770, (int)771);
                        this.drawTex(this.tex.id, 4);
                        GL11.glDisable((int)3042);
                        break;
                    }
                    this.drawTex(this.tex.id, 4);
                    break;
                }
                case 5: {
                    if (this.fontTexture.format == 6408) {
                        GL11.glEnable((int)3042);
                        GL11.glBlendFunc((int)770, (int)771);
                        this.drawTex(this.fontTexture.id, 4);
                        GL11.glDisable((int)3042);
                        break;
                    }
                    this.drawTex(this.fontTexture.id, 4);
                }
            }
        }
        this.bufferType = 0;
        this.buffering = false;
    }

    public void fillPolygon(float f, float f2, float f3, float f4, float f5, float f6) {
        this.bufferType = 7;
        if (this.buffering) {
            this.bufferTriangle(f, f2, f3, f4, f5, f6);
        } else {
            this.begin();
            this.bufferTriangle(f, f2, f3, f4, f5, f6);
            this.end();
        }
    }

    public void fillRect(float f, float f2, float f3, float f4) {
        this.bufferType = 6;
        if (this.buffering) {
            this.bufferTrianglesRect(f, f2, f3, f4);
        } else {
            this.begin();
            this.bufferTrianglesRect(f, f2, f3, f4);
            this.end();
        }
    }

    public void fillTriangle(float f, float f2, float f3, float f4, float f5, float f6) {
        this.bufferType = 7;
        if (this.buffering) {
            this.bufferPoint(f, f2);
            this.bufferPoint(f3, f4);
            this.bufferPoint(f5, f6);
        } else {
            this.begin();
            this.bufferPoint(f, f2);
            this.bufferPoint(f3, f4);
            this.bufferPoint(f5, f6);
            this.end();
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void init2D(int n, int n2, int n3, int n4) {
        GL11.glViewport((int)0, (int)0, (int)n, (int)n2);
        Math3D.setOrtho2DProjectionMatrix(0.0f, n3, n4, 0.0f, this.projectionMatrix);
        this.modelViewMatrix.identity();
    }

    public void popMatrix() {
        this.modelViewMatrix.set(this.matrixStack[this.matrixStackPtr]);
        --this.matrixStackPtr;
    }

    public void pushMatrix() {
        ++this.matrixStackPtr;
        if (this.matrixStack[this.matrixStackPtr] == null) {
            this.matrixStack[this.matrixStackPtr] = new Matrix4f(this.modelViewMatrix);
        } else {
            this.matrixStack[this.matrixStackPtr].set(this.modelViewMatrix);
        }
    }

    public void rotatef(float f, float f2, float f3) {
        this.v.x = f2;
        this.v.y = f3;
        this.modelViewMatrix.rotate(f, this.v);
    }

    public void scalef(float f, float f2) {
        this.v.x = f;
        this.v.y = f2;
        this.modelViewMatrix.scale(this.v);
    }

    public void setColor(float f, float f2, float f3, float f4) {
        this.color[0] = f;
        this.color[1] = f2;
        this.color[2] = f3;
        this.color[3] = f4;
    }

    public void setColor(float[] fArray) {
        this.color[0] = fArray[0];
        this.color[1] = fArray[1];
        this.color[2] = fArray[2];
        this.color[3] = fArray[3];
    }

    public void setFont(Font font) {
        this.font = font;
        if (!this.fontTextures.containsKey(font.id)) {
            Texture texture = TextureFactory.createTexture(font.image);
            assert (texture != null);
            this.fontTextures.put(font.id, texture);
        }
        this.fontTexture = this.fontTextures.get(font.id);
        this.srcFontRect.width = font.charWidth;
        this.srcFontRect.height = font.charHeight;
        this.dstFontRect.width = font.charWidth;
        this.dstFontRect.height = font.charHeight;
    }

    public void setFontSize(int n, int n2) {
        this.dstFontRect.width = n;
        this.dstFontRect.height = n2;
    }

    public void translatef(float f, float f2) {
        this.v.x = f;
        this.v.y = f2;
        this.modelViewMatrix.translate(this.v);
    }
}

