/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StaticXML {
    public static void errAttributeMissing(Element element, String string) {
        throw new AssertionError((Object)("tag '" + element.getTagName() + "' missing attribute '" + string + "' in " + element.getOwnerDocument().getDocumentURI()));
    }

    public static void errUnknownTag(Element element) {
        throw new AssertionError((Object)("Unknown tag: '" + element.getTagName() + "' in " + element.getOwnerDocument().getDocumentURI()));
    }

    public static void errInvalidAttributeValue(Element element, String string, String string2) {
        throw new AssertionError((Object)("Invalid value for attribute " + string + "='" + string2 + "' in " + element.getOwnerDocument().getDocumentURI()));
    }

    public static Document createDocument() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            return null;
        }
    }

    public static void saveXML(Document document, File file) {
        try {
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(file);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "no");
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
    }

    public static Element createTextElement(Document document, String string, boolean bl) {
        return StaticXML.createTextElement(document, string, String.valueOf(bl));
    }

    public static Element createTextElement(Document document, String string, float f) {
        return StaticXML.createTextElement(document, string, String.valueOf(f));
    }

    public static Element createTextElement(Document document, String string, int n) {
        return StaticXML.createTextElement(document, string, String.valueOf(n));
    }

    public static Element createTextElement(Document document, String string, long l) {
        return StaticXML.createTextElement(document, string, String.valueOf(l));
    }

    public static Element createTextElement(Document document, String string, String string2) {
        if (string2 == null || string2.isEmpty()) {
            return null;
        }
        Element element = document.createElement(string);
        element.setTextContent(string2);
        return element;
    }

    public static String getAttribute(Element element, String string) {
        if (!element.hasAttribute(string)) {
            StaticXML.errAttributeMissing(element, string);
        }
        return element.getAttribute(string);
    }

    public static String getAttribute(Element element, String string, String string2) {
        if (element.hasAttribute(string)) {
            return element.getAttribute(string);
        }
        return string2;
    }

    public static boolean getBool(Element element, String string) {
        return Boolean.valueOf(StaticXML.getAttribute(element, string));
    }

    public static boolean getBool(Element element, String string, boolean bl) {
        return StaticXML.hasAttribute(element, string) ? StaticXML.getBool(element, string) : bl;
    }

    public static List<Attr> getAttributes(Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        ArrayList<Attr> arrayList = new ArrayList<Attr>();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            if (node.getNodeType() != 2) continue;
            arrayList.add((Attr)node);
        }
        return arrayList;
    }

    public static List<Element> getChildElements(Element element) {
        NodeList nodeList = element.getChildNodes();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            arrayList.add((Element)node);
        }
        return arrayList;
    }

    public static Element getElement(Element element, String string) {
        for (Element element2 : StaticXML.getChildElements(element)) {
            if (!element2.getTagName().equals(string)) continue;
            return element2;
        }
        return null;
    }

    public static List<Element> getElements(Element element, String string) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Element element2 : StaticXML.getChildElements(element)) {
            if (!element2.getTagName().equals(string)) continue;
            arrayList.add(element2);
        }
        return arrayList;
    }

    public static float getFloat(Element element, String string) {
        return Float.valueOf(StaticXML.getAttribute(element, string)).floatValue();
    }

    public static float getFloat(Element element, String string, float f) {
        return StaticXML.hasAttribute(element, string) ? Float.valueOf(StaticXML.getAttribute(element, string)).floatValue() : f;
    }

    public static int getInt(Element element, String string) {
        return Integer.valueOf(StaticXML.getAttribute(element, string));
    }

    public static int getInt(Element element, String string, int n) {
        return StaticXML.hasAttribute(element, string) ? StaticXML.getInt(element, string) : n;
    }

    public static long getLong(Element element, String string) {
        return Long.valueOf(StaticXML.getAttribute(element, string));
    }

    public static long getLong(Element element, String string, long l) {
        return StaticXML.hasAttribute(element, string) ? Long.valueOf(StaticXML.getAttribute(element, string)) : l;
    }

    public static String getText(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            return node.getNodeValue();
        }
        return null;
    }

    public static boolean hasAttribute(Element element, String string) {
        return element.hasAttribute(string);
    }

    public static boolean hasText(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            return true;
        }
        return false;
    }

    public static boolean hasText(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            return true;
        }
        return false;
    }

    public static Document loadXML(File file) throws SAXException, IOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(file);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            return null;
        }
    }

    public static Document loadXML(InputStream inputStream) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            document.getDocumentElement().normalize();
            return document;
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        return null;
    }

    public static Document loadXML(String string) {
        return StaticXML.loadXML(new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8)));
    }

    public static List<Element> removeChildren(Element element) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            arrayList.add(nodeList.item(i));
        }
        ArrayList<Element> arrayList2 = new ArrayList<Element>();
        for (Node node : arrayList) {
            if (node.getNodeType() == 1) {
                arrayList2.add((Element)node);
            }
            element.removeChild(node);
        }
        return arrayList2;
    }
}

