/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.sasm.binding.core;

import de.slashbinbash.sasm.binding.IBinding;
import de.slashbinbash.sasm.binding.IModule;
import de.slashbinbash.sasm.interpreter.DataStack;
import de.slashbinbash.sasm.interpreter.IInterpreter;
import de.slashbinbash.sasm.type.BooleanType;
import de.slashbinbash.sasm.type.DataType;
import de.slashbinbash.sasm.type.DataTypeUtil;

public class Bool
implements IModule {
    public static final String NAME = "bool";

    @Override
    public IBinding[] createBindings() {
        return new IBinding[]{new And(), new Not(), new Or(), new Xor()};
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static class And
    implements IBinding {
        public static final String NAME = "and";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            int n = Math.max(dataStack.getNumArgs(), 2);
            boolean bl = DataTypeUtil.toBool((DataType)dataStack.pop());
            --n;
            while (n > 0) {
                bl &= DataTypeUtil.toBool((DataType)dataStack.pop());
                --n;
            }
            dataStack.push(BooleanType.getInstance(bl));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Not
    implements IBinding {
        public static final String NAME = "not";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            boolean bl = DataTypeUtil.toBool((DataType)dataStack.pop());
            dataStack.push(BooleanType.getInstance(!bl));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Or
    implements IBinding {
        public static final String NAME = "or";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            int n = Math.max(dataStack.getNumArgs(), 2);
            boolean bl = DataTypeUtil.toBool((DataType)dataStack.pop());
            --n;
            while (n > 0) {
                bl |= DataTypeUtil.toBool((DataType)dataStack.pop());
                --n;
            }
            dataStack.push(BooleanType.getInstance(bl));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Xor
    implements IBinding {
        public static final String NAME = "xor";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            int n = Math.max(dataStack.getNumArgs(), 2);
            boolean bl = DataTypeUtil.toBool((DataType)dataStack.pop());
            --n;
            while (n > 0) {
                bl ^= DataTypeUtil.toBool((DataType)dataStack.pop());
                --n;
            }
            dataStack.push(BooleanType.getInstance(bl));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }
}

