/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.sasm.binding.core;

import de.slashbinbash.sasm.binding.IBinding;
import de.slashbinbash.sasm.binding.IModule;
import de.slashbinbash.sasm.interpreter.DataStack;
import de.slashbinbash.sasm.interpreter.IInterpreter;
import de.slashbinbash.sasm.type.DataType;
import de.slashbinbash.sasm.type.DataTypeUtil;

public class Debug
implements IModule {
    public static final String NAME = "debug";

    @Override
    public IBinding[] createBindings() {
        return new IBinding[]{new Assert(), new PrintStack()};
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static class Assert
    implements IBinding {
        public static final String NAME = "assert";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            String string = DataTypeUtil.toStr((DataType)dataStack.pop());
            boolean bl = DataTypeUtil.toBool((DataType)dataStack.pop());
            assert (bl) : string;
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class PrintStack
    implements IBinding {
        public static final String NAME = "printstack";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            System.out.println(dataStack.toString());
        }

        @Override
        public String getName() {
            return NAME;
        }
    }
}

