/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.sasm.binding.core;

import de.slashbinbash.sasm.binding.IBinding;
import de.slashbinbash.sasm.binding.IModule;
import de.slashbinbash.sasm.interpreter.DataStack;
import de.slashbinbash.sasm.interpreter.IInterpreter;
import de.slashbinbash.sasm.interpreter.Util;
import de.slashbinbash.sasm.type.DataType;
import de.slashbinbash.sasm.type.DataTypeUtil;
import de.slashbinbash.sasm.type.ListType;
import de.slashbinbash.sasm.type.StringType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;

public class IO
implements IModule {
    public static final String NAME = "io";

    public static String read(File file) throws IOException {
        FileReader fileReader = new FileReader(file);
        CharBuffer charBuffer = CharBuffer.allocate((int)file.length());
        int n = fileReader.read(charBuffer);
        fileReader.close();
        if (n != 0) {
            charBuffer.flip();
        }
        return charBuffer.toString();
    }

    public static List<String> readLines(File file) throws IOException {
        String string;
        FileReader fileReader = new FileReader(file);
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string);
        }
        fileReader.close();
        return arrayList;
    }

    public static void write(String string, File file) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(string);
        fileWriter.close();
    }

    @Override
    public IBinding[] createBindings() {
        return new IBinding[]{new Print(), new ReadArgs(), new ReadLines(), new WriteArgs(), new WriteFile()};
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static class Print
    implements IBinding {
        public static final String NAME = "print";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            int n = Math.max(dataStack.getNumArgs(), 1);
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(((DataType)dataStack.pop()).toString());
            }
            System.out.println(stringBuilder.toString());
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class ReadArgs
    implements IBinding {
        public static final String NAME = "readargs";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            try {
                String string = DataTypeUtil.toStr((DataType)dataStack.pop());
                String string2 = Util.cleanArgs(IO.read(new File(string)));
                ArrayList<DataType> arrayList = new ArrayList<DataType>();
                Util.parseArgs(string2, arrayList);
                dataStack.pushAll(arrayList);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class ReadLines
    implements IBinding {
        public static final String NAME = "readlines";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            try {
                String string = DataTypeUtil.toStr((DataType)dataStack.pop());
                List<String> list = IO.readLines(new File(string));
                ArrayList<DataType> arrayList = new ArrayList<DataType>();
                for (String string2 : list) {
                    arrayList.add(StringType.getInstance(string2));
                }
                dataStack.push(new ListType(arrayList));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class WriteArgs
    implements IBinding {
        public static final String NAME = "writeargs";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            try {
                String string = DataTypeUtil.toStr((DataType)dataStack.pop());
                DataType dataType = (DataType)dataStack.pop();
                StringBuilder stringBuilder = new StringBuilder();
                Util.writeArgs(dataType, stringBuilder);
                IO.write(stringBuilder.toString(), new File(string));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class WriteFile
    implements IBinding {
        public static final String NAME = "writefile";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            try {
                String string = DataTypeUtil.toStr((DataType)dataStack.pop());
                String string2 = DataTypeUtil.toStr((DataType)dataStack.pop());
                IO.write(string2, new File(string));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        @Override
        public String getName() {
            return NAME;
        }
    }
}

