/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.sasm.binding.core;

import de.slashbinbash.sasm.binding.IBinding;
import de.slashbinbash.sasm.binding.IModule;
import de.slashbinbash.sasm.interpreter.DataStack;
import de.slashbinbash.sasm.interpreter.IInterpreter;
import de.slashbinbash.sasm.type.BooleanType;
import de.slashbinbash.sasm.type.DataType;
import de.slashbinbash.sasm.type.DataTypeUtil;
import de.slashbinbash.sasm.type.IntegerType;
import de.slashbinbash.sasm.type.ListType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Lst
implements IModule {
    public static final String NAME = "list";
    private static final IBinding[] BINDINGS = new IBinding[]{new Append(), new Assoc(), new Assocs(), new Copy(), new Create(), new Filter(), new ForEach(), new Get(), new Group(), new Head(), new IndexOf(), new Init(), new IsEmpty(), new Last(), new Map(), new Merge(), new Pack(), new Reduce(), new Reverse(), new Rotate(), new Split(), new Size(), new Sort(), new SubList(), new Tail(), new Unpack(), new Zip(), new ZipWith()};

    @Override
    public IBinding[] createBindings() {
        return BINDINGS;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static class Append
    implements IBinding {
        public static final String NAME = "append";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            DataType dataType = (DataType)dataStack.pop();
            DataType dataType2 = (DataType)dataStack.pop();
            ListType listType = DataTypeUtil.toList(dataType2);
            listType.add(dataType);
            dataStack.push(dataType2);
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Assoc
    implements IBinding {
        public static final String NAME = "assoc";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            DataType dataType = (DataType)dataStack.pop();
            ListType listType = DataTypeUtil.toList((DataType)dataStack.pop());
            for (int i = 0; i < listType.size(); i += 2) {
                if (!listType.get(i).equals(dataType)) continue;
                dataStack.push(listType.get(i + 1));
                return;
            }
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Assocs
    implements IBinding {
        public static final String NAME = "assocs";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            DataType dataType = (DataType)dataStack.pop();
            DataType dataType2 = (DataType)dataStack.pop();
            DataType dataType3 = (DataType)dataStack.pop();
            ListType listType = DataTypeUtil.toList(dataType3);
            for (int i = 0; i < listType.size(); i += 2) {
                if (!listType.get(i).equals(dataType)) continue;
                listType.set(i + 1, dataType2);
                break;
            }
            dataStack.push(dataType3);
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Copy
    implements IBinding {
        public static final String NAME = "copy";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            DataType dataType = (DataType)dataStack.pop();
            if (dataType instanceof ListType) {
                ListType listType = (ListType)dataType;
                dataStack.push(new ListType(listType));
            } else assert (false);
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Create
    implements IBinding {
        public static final String NAME = "create";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            int n = dataStack.getNumArgs();
            DataType[] dataTypeArray = new DataType[n];
            for (int i = 0; i < n; ++i) {
                dataTypeArray[i] = (DataType)dataStack.pop();
            }
            dataStack.push(new ListType(dataTypeArray));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Filter
    implements IBinding {
        public static final String NAME = "filter";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            DataType dataType = (DataType)dataStack.pop();
            ListType listType = DataTypeUtil.toList((DataType)dataStack.pop());
            if (listType.isEmpty()) {
                dataStack.push(ListType.EMPTY);
                return;
            }
            ArrayList<DataType> arrayList = new ArrayList<DataType>(listType.size());
            for (int i = 0; i < listType.size(); ++i) {
                DataType dataType2 = listType.get(i);
                dataStack.push(dataType2);
                dataStack.push(dataType);
                iInterpreter.execRun();
                BooleanType booleanType = (BooleanType)dataStack.pop();
                if (!booleanType.value) continue;
                arrayList.add(dataType2);
            }
            dataStack.push(new ListType(arrayList));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class ForEach
    implements IBinding {
        public static final String NAME = "foreach";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            DataType dataType = (DataType)dataStack.pop();
            ListType listType = DataTypeUtil.toList((DataType)dataStack.pop());
            for (int i = 0; i < listType.size(); ++i) {
                DataType dataType2 = listType.get(i);
                dataStack.push(dataType2);
                dataStack.push(dataType);
                iInterpreter.execRun();
            }
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Get
    implements IBinding {
        public static final String NAME = "get";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            int n = DataTypeUtil.toInt((DataType)dataStack.pop());
            ListType listType = DataTypeUtil.toList((DataType)dataStack.pop());
            dataStack.push(listType.get(n));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Group
    implements IBinding {
        public static final String NAME = "group";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            ListType listType = DataTypeUtil.toList((DataType)dataStack.pop());
            if (listType.isEmpty()) {
                dataStack.push(ListType.EMPTY);
                return;
            }
            ArrayList<DataType> arrayList = new ArrayList<DataType>(listType.size());
            DataType dataType = listType.get(0);
            arrayList.add(dataType);
            for (int i = 1; i < listType.size(); ++i) {
                DataType dataType2 = listType.get(i);
                if (dataType2.isSame(dataType) && dataType2.compareTo(dataType) == 0) continue;
                dataType = dataType2;
                arrayList.add(dataType2);
            }
            dataStack.push(new ListType(arrayList));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Head
    implements IBinding {
        public static final String NAME = "head";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            ListType listType = DataTypeUtil.toList((DataType)dataStack.pop());
            dataStack.push(listType.get(0));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class IndexOf
    implements IBinding {
        public static final String NAME = "indexof";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            DataType dataType = (DataType)dataStack.pop();
            ListType listType = DataTypeUtil.toList((DataType)dataStack.pop());
            int n = listType.indexOf(dataType);
            dataStack.push(new IntegerType(n));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Init
    implements IBinding {
        public static final String NAME = "init";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            ListType listType = DataTypeUtil.toList((DataType)dataStack.pop());
            List<DataType> list = listType.subList(0, listType.size() - 1);
            dataStack.push(new ListType(list));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class IsEmpty
    implements IBinding {
        public static final String NAME = "isempty";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            ListType listType = DataTypeUtil.toList((DataType)dataStack.pop());
            dataStack.push(BooleanType.getInstance(listType.isEmpty()));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Last
    implements IBinding {
        public static final String NAME = "last";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            ListType listType = DataTypeUtil.toList((DataType)dataStack.pop());
            dataStack.push(listType.getLast());
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Map
    implements IBinding {
        public static final String NAME = "map";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            DataType dataType = (DataType)dataStack.pop();
            ListType listType = DataTypeUtil.toList((DataType)dataStack.pop());
            if (listType.isEmpty()) {
                dataStack.push(ListType.EMPTY);
                return;
            }
            ArrayList<DataType> arrayList = new ArrayList<DataType>(listType.size());
            for (int i = 0; i < listType.size(); ++i) {
                DataType dataType2 = listType.get(i);
                dataStack.push(dataType2);
                dataStack.push(dataType);
                iInterpreter.execRun();
                arrayList.add((DataType)dataStack.pop());
            }
            dataStack.push(new ListType(arrayList));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Merge
    implements IBinding {
        public static final String NAME = "merge";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            int n;
            ListType listType = DataTypeUtil.toList((DataType)dataStack.pop());
            ListType listType2 = DataTypeUtil.toList((DataType)dataStack.pop());
            ArrayList<DataType> arrayList = new ArrayList<DataType>(listType.size() + listType2.size());
            for (n = 0; n < listType.size(); ++n) {
                arrayList.add(listType.get(n));
            }
            for (n = 0; n < listType2.size(); ++n) {
                arrayList.add(listType2.get(n));
            }
            dataStack.push(new ListType(arrayList));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Pack
    implements IBinding {
        public static final String NAME = "pack";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            int n = DataTypeUtil.toInt((DataType)dataStack.pop());
            DataType[] dataTypeArray = new DataType[n];
            for (int i = 0; i < n; ++i) {
                dataTypeArray[i] = (DataType)dataStack.pop();
            }
            dataStack.push(new ListType(dataTypeArray));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Reduce
    implements IBinding {
        public static final String NAME = "reduce";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            DataType dataType = (DataType)dataStack.pop();
            ListType listType = DataTypeUtil.toList((DataType)dataStack.pop());
            DataType dataType2 = listType.get(0);
            for (int i = 1; i < listType.size(); ++i) {
                DataType dataType3 = listType.get(i);
                dataStack.push(dataType3);
                dataStack.push(dataType2);
                dataStack.push(dataType);
                iInterpreter.execRun();
                dataType2 = (DataType)dataStack.pop();
            }
            dataStack.push(dataType2);
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Reverse
    implements IBinding {
        public static final String NAME = "reverse";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            ListType listType = DataTypeUtil.toList((DataType)dataStack.pop());
            int n = listType.size();
            ArrayList<DataType> arrayList = new ArrayList<DataType>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(listType.get(n - i - 1));
            }
            dataStack.push(new ListType(arrayList));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Rotate
    implements IBinding {
        public static final String NAME = "rotate";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            int n = DataTypeUtil.toInt((DataType)dataStack.pop());
            ListType listType = DataTypeUtil.toList((DataType)dataStack.pop());
            int n2 = listType.size();
            ArrayList<DataType> arrayList = new ArrayList<DataType>(n2);
            for (int i = 0; i < listType.size(); ++i) {
                int n3 = i + n;
                if (n3 < 0) {
                    n3 = n2 + n3 % n2;
                }
                arrayList.add(listType.get(n3 %= n2));
            }
            dataStack.push(new ListType(arrayList));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Split
    implements IBinding {
        public static final String NAME = "split";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            DataType dataType = (DataType)dataStack.pop();
            ListType listType = DataTypeUtil.toList((DataType)dataStack.pop());
            ArrayList<DataType> arrayList = new ArrayList<DataType>();
            ArrayList<DataType> arrayList2 = new ArrayList<DataType>();
            for (int i = 0; i < listType.size(); ++i) {
                DataType dataType2 = listType.get(i);
                dataStack.push(dataType2);
                dataStack.push(dataType);
                iInterpreter.execRun();
                boolean bl = DataTypeUtil.toBool((DataType)dataStack.pop());
                if (bl) {
                    arrayList.add(dataType2);
                    continue;
                }
                arrayList2.add(dataType2);
            }
            dataStack.push(new ListType(arrayList2));
            dataStack.push(new ListType(arrayList));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Size
    implements IBinding {
        public static final String NAME = "size";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            ListType listType = (ListType)dataStack.peek();
            int n = listType.size();
            dataStack.push(new IntegerType(n));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Sort
    implements IBinding {
        public static final String NAME = "sort";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            ListType listType = DataTypeUtil.toList((DataType)dataStack.pop());
            ArrayList<DataType> arrayList = new ArrayList<DataType>(listType.size());
            for (int i = 0; i < listType.size(); ++i) {
                arrayList.add(listType.get(i));
            }
            Collections.sort(arrayList, new DataTypeComparator());
            dataStack.push(new ListType(arrayList));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class SubList
    implements IBinding {
        public static final String NAME = "sublist";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            int n = DataTypeUtil.toInt((DataType)dataStack.pop());
            int n2 = DataTypeUtil.toInt((DataType)dataStack.pop());
            ListType listType = DataTypeUtil.toList((DataType)dataStack.pop());
            List<DataType> list = listType.subList(n, n2);
            dataStack.push(new ListType(list));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Tail
    implements IBinding {
        public static final String NAME = "tail";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            ListType listType = DataTypeUtil.toList((DataType)dataStack.pop());
            dataStack.push(new ListType(listType.subList(1, listType.size())));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Unpack
    implements IBinding {
        public static final String NAME = "unpack";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            ListType listType = DataTypeUtil.toList((DataType)dataStack.pop());
            for (int i = listType.size() - 1; i >= 0; --i) {
                dataStack.push(listType.get(i));
            }
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Zip
    implements IBinding {
        public static final String NAME = "zip";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            ListType listType = DataTypeUtil.toList((DataType)dataStack.pop());
            ListType listType2 = DataTypeUtil.toList((DataType)dataStack.pop());
            ArrayList<DataType> arrayList = new ArrayList<DataType>(listType.size() + listType2.size());
            int n = Math.max(listType.size(), listType2.size());
            for (int i = 0; i < n; ++i) {
                if (i < listType.size()) {
                    arrayList.add(listType.get(i));
                }
                if (i >= listType2.size()) continue;
                arrayList.add(listType2.get(i));
            }
            dataStack.push(new ListType(arrayList));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class ZipWith
    implements IBinding {
        public static final String NAME = "zipwith";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            DataType dataType = (DataType)dataStack.pop();
            ListType listType = DataTypeUtil.toList((DataType)dataStack.pop());
            ListType listType2 = DataTypeUtil.toList((DataType)dataStack.pop());
            ArrayList<DataType> arrayList = new ArrayList<DataType>(listType.size() + listType2.size());
            int n = Math.max(listType.size(), listType2.size());
            for (int i = 0; i < n; ++i) {
                if (i < listType.size() && i < listType2.size()) {
                    DataType dataType2 = listType.get(i);
                    DataType dataType3 = listType2.get(i);
                    dataStack.push(dataType3);
                    dataStack.push(dataType2);
                    dataStack.push(dataType);
                    iInterpreter.execRun();
                    arrayList.add((DataType)dataStack.pop());
                    continue;
                }
                if (i < listType.size()) {
                    arrayList.add(listType.get(i));
                    continue;
                }
                if (i < listType2.size()) {
                    arrayList.add(listType2.get(i));
                    continue;
                }
                assert (false);
            }
            dataStack.push(new ListType(arrayList));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    private static class DataTypeComparator
    implements Comparator<DataType> {
        private DataTypeComparator() {
        }

        @Override
        public int compare(DataType dataType, DataType dataType2) {
            if (!dataType.isSame(dataType2)) {
                return 0;
            }
            return dataType.compareTo(dataType2);
        }
    }
}

