/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.sasm.binding.core;

import de.slashbinbash.sasm.binding.IBinding;
import de.slashbinbash.sasm.binding.IModule;
import de.slashbinbash.sasm.interpreter.DataStack;
import de.slashbinbash.sasm.interpreter.IInterpreter;
import de.slashbinbash.sasm.type.DataType;
import de.slashbinbash.sasm.type.DataTypeUtil;
import de.slashbinbash.sasm.type.IntegerType;

public class Math
implements IModule {
    public static final String NAME = "math";

    @Override
    public IBinding[] createBindings() {
        return new IBinding[]{new Abs(), new Add(), new Dec(), new Div(), new Inc(), new Mod(), new Mul(), new Pow(), new Sqrt(), new Sub()};
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static class Abs
    implements IBinding {
        public static final String NAME = "abs";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            DataType dataType = (DataType)dataStack.pop();
            if (!dataType.isInteger()) {
                throw new UnsupportedOperationException();
            }
            int n = DataTypeUtil.toInt(dataType);
            int n2 = java.lang.Math.abs(n);
            dataStack.push(new IntegerType(n2));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Add
    implements IBinding {
        public static final String NAME = "add";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            int n;
            if (((DataType)dataStack.peek()).isInteger()) {
                int n2 = java.lang.Math.max(dataStack.getNumArgs(), 2);
                n = DataTypeUtil.toInt((DataType)dataStack.pop());
                --n2;
                while (n2 > 0) {
                    n += DataTypeUtil.toInt((DataType)dataStack.pop());
                    --n2;
                }
            } else {
                throw new UnsupportedOperationException();
            }
            dataStack.push(new IntegerType(n));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Dec
    implements IBinding {
        public static final String NAME = "dec";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            DataType dataType = (DataType)dataStack.pop();
            if (!dataType.isInteger()) {
                throw new UnsupportedOperationException();
            }
            int n = DataTypeUtil.toInt(dataType);
            int n2 = n - 1;
            dataStack.push(new IntegerType(n2));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Div
    implements IBinding {
        public static final String NAME = "div";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            int n;
            if (((DataType)dataStack.peek()).isInteger()) {
                int n2 = java.lang.Math.max(dataStack.getNumArgs(), 2);
                n = DataTypeUtil.toInt((DataType)dataStack.pop());
                --n2;
                while (n2 > 0) {
                    n /= DataTypeUtil.toInt((DataType)dataStack.pop());
                    --n2;
                }
            } else {
                throw new UnsupportedOperationException();
            }
            dataStack.push(new IntegerType(n));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Inc
    implements IBinding {
        public static final String NAME = "inc";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            DataType dataType = (DataType)dataStack.pop();
            if (!dataType.isInteger()) {
                throw new UnsupportedOperationException();
            }
            int n = DataTypeUtil.toInt(dataType);
            int n2 = n + 1;
            dataStack.push(new IntegerType(n2));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Mod
    implements IBinding {
        public static final String NAME = "mod";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            DataType dataType = (DataType)dataStack.pop();
            DataType dataType2 = (DataType)dataStack.pop();
            if (!dataType.isInteger() || !dataType2.isInteger()) {
                throw new UnsupportedOperationException();
            }
            int n = DataTypeUtil.toInt(dataType);
            int n2 = DataTypeUtil.toInt(dataType2);
            int n3 = n % n2;
            dataStack.push(new IntegerType(n3));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Mul
    implements IBinding {
        public static final String NAME = "mul";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            int n;
            if (((DataType)dataStack.peek()).isInteger()) {
                int n2 = java.lang.Math.max(dataStack.getNumArgs(), 2);
                n = DataTypeUtil.toInt((DataType)dataStack.pop());
                --n2;
                while (n2 > 0) {
                    n *= DataTypeUtil.toInt((DataType)dataStack.pop());
                    --n2;
                }
            } else {
                throw new UnsupportedOperationException();
            }
            dataStack.push(new IntegerType(n));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Pow
    implements IBinding {
        public static final String NAME = "pow";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            DataType dataType = (DataType)dataStack.pop();
            DataType dataType2 = (DataType)dataStack.pop();
            if (!dataType.isInteger() || !dataType2.isInteger()) {
                throw new UnsupportedOperationException();
            }
            int n = DataTypeUtil.toInt(dataType);
            int n2 = DataTypeUtil.toInt(dataType2);
            int n3 = (int)java.lang.Math.pow(n, n2);
            dataStack.push(new IntegerType(n3));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Sqrt
    implements IBinding {
        public static final String NAME = "sqrt";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            DataType dataType = (DataType)dataStack.pop();
            if (!dataType.isInteger()) {
                throw new UnsupportedOperationException();
            }
            int n = DataTypeUtil.toInt(dataType);
            int n2 = (int)java.lang.Math.sqrt(n);
            dataStack.push(new IntegerType(n2));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Sub
    implements IBinding {
        public static final String NAME = "sub";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            int n;
            if (((DataType)dataStack.peek()).isInteger()) {
                int n2 = java.lang.Math.max(dataStack.getNumArgs(), 2);
                n = DataTypeUtil.toInt((DataType)dataStack.pop());
                --n2;
                while (n2 > 0) {
                    n -= DataTypeUtil.toInt((DataType)dataStack.pop());
                    --n2;
                }
            } else {
                throw new UnsupportedOperationException();
            }
            dataStack.push(new IntegerType(n));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }
}

