/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.sasm.binding.core;

import de.slashbinbash.sasm.binding.IBinding;
import de.slashbinbash.sasm.binding.IModule;
import de.slashbinbash.sasm.interpreter.DataStack;
import de.slashbinbash.sasm.interpreter.IInterpreter;
import de.slashbinbash.sasm.type.DataType;
import de.slashbinbash.sasm.type.IntegerType;

public class Stack
implements IModule {
    public static final String NAME = "stack";

    @Override
    public IBinding[] createBindings() {
        return new IBinding[]{new Drop(), new Dup(), new Over(), new Rot(), new Size(), new Swap()};
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static class Drop
    implements IBinding {
        public static final String NAME = "drop";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            assert (dataStack.size() >= 1);
            dataStack.pop();
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Dup
    implements IBinding {
        public static final String NAME = "dup";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            assert (dataStack.size() >= 1);
            dataStack.push((DataType)dataStack.peek());
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Over
    implements IBinding {
        public static final String NAME = "over";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            assert (dataStack.size() >= 2);
            dataStack.push((DataType)dataStack.get(dataStack.size() - 2));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Rot
    implements IBinding {
        public static final String NAME = "rot";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            assert (dataStack.size() >= 3);
            DataType dataType = (DataType)dataStack.pop();
            DataType dataType2 = (DataType)dataStack.pop();
            DataType dataType3 = (DataType)dataStack.pop();
            dataStack.push(dataType);
            dataStack.push(dataType3);
            dataStack.push(dataType2);
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Size
    implements IBinding {
        public static final String NAME = "size";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            int n = dataStack.size();
            dataStack.push(new IntegerType(n));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Swap
    implements IBinding {
        public static final String NAME = "swap";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            assert (dataStack.size() >= 2);
            DataType dataType = (DataType)dataStack.pop();
            DataType dataType2 = (DataType)dataStack.pop();
            dataStack.push(dataType);
            dataStack.push(dataType2);
        }

        @Override
        public String getName() {
            return NAME;
        }
    }
}

