/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.sasm.binding.core;

import de.slashbinbash.sasm.binding.IBinding;
import de.slashbinbash.sasm.binding.IModule;
import de.slashbinbash.sasm.interpreter.DataStack;
import de.slashbinbash.sasm.interpreter.IInterpreter;
import de.slashbinbash.sasm.type.DataType;
import de.slashbinbash.sasm.type.DataTypeUtil;
import de.slashbinbash.sasm.type.IntegerType;
import de.slashbinbash.sasm.type.ListType;
import de.slashbinbash.sasm.type.StringType;
import java.util.ArrayList;

public class Str
implements IModule {
    public static final String NAME = "str";

    @Override
    public IBinding[] createBindings() {
        return new IBinding[]{new Concat(), new Explode(), new Length(), new Split(), new Substring(), new ToLower(), new ToUpper()};
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static class Concat
    implements IBinding {
        public static final String NAME = "concat";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = Math.max(dataStack.getNumArgs(), 2); i > 0; --i) {
                stringBuilder.append(DataTypeUtil.toStr((DataType)dataStack.pop()));
            }
            dataStack.push(StringType.getInstance(stringBuilder.toString()));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Explode
    implements IBinding {
        public static final String NAME = "explode";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            String string = DataTypeUtil.toStr((DataType)dataStack.pop());
            ArrayList<DataType> arrayList = new ArrayList<DataType>(string.length());
            for (int i = 0; i < string.length(); ++i) {
                StringType stringType = StringType.getInstance(String.valueOf(string.charAt(i)));
                arrayList.add(stringType);
            }
            dataStack.push(new ListType(arrayList));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Length
    implements IBinding {
        public static final String NAME = "len";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            String string = DataTypeUtil.toStr((DataType)dataStack.pop());
            int n = string.length();
            dataStack.push(new IntegerType(n));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Split
    implements IBinding {
        public static final String NAME = "split";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            String string = DataTypeUtil.toStr((DataType)dataStack.pop());
            String string2 = DataTypeUtil.toStr((DataType)dataStack.pop());
            String[] stringArray = string2.split(string);
            DataType[] dataTypeArray = new DataType[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                dataTypeArray[i] = StringType.getInstance(stringArray[i]);
            }
            dataStack.push(new ListType(dataTypeArray));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Substring
    implements IBinding {
        public static final String NAME = "substr";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            int n = DataTypeUtil.toInt((DataType)dataStack.pop());
            int n2 = DataTypeUtil.toInt((DataType)dataStack.pop());
            String string = DataTypeUtil.toStr((DataType)dataStack.pop());
            CharSequence charSequence = string.subSequence(n, n2);
            dataStack.push(StringType.getInstance(charSequence));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class ToLower
    implements IBinding {
        public static final String NAME = "tolower";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            String string = DataTypeUtil.toStr((DataType)dataStack.pop());
            dataStack.push(StringType.getInstance(string.toLowerCase()));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class ToUpper
    implements IBinding {
        public static final String NAME = "toupper";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            String string = DataTypeUtil.toStr((DataType)dataStack.pop());
            dataStack.push(StringType.getInstance(string.toUpperCase()));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }
}

