/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.sasm.binding.core;

import de.slashbinbash.sasm.Main;
import de.slashbinbash.sasm.binding.IBinding;
import de.slashbinbash.sasm.binding.IModule;
import de.slashbinbash.sasm.interpreter.DataStack;
import de.slashbinbash.sasm.interpreter.IInterpreter;
import de.slashbinbash.sasm.type.BooleanType;
import de.slashbinbash.sasm.type.DataType;
import de.slashbinbash.sasm.type.DataTypeUtil;
import de.slashbinbash.sasm.type.IntegerType;
import de.slashbinbash.sasm.type.ListType;
import de.slashbinbash.sasm.type.NameType;
import de.slashbinbash.sasm.type.StringType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class Sys
implements IModule {
    public static final String NAME = "sys";

    @Override
    public IBinding[] createBindings() {
        return new IBinding[]{new Args(), new Exec(this), new Exit(), new ReadIn(), new WriteErr(), new WriteOut()};
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static class Args
    implements IBinding {
        public static final String NAME = "args";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            ArrayList<DataType> arrayList = new ArrayList<DataType>();
            for (String string : Main.args) {
                arrayList.add(StringType.getInstance(string));
            }
            dataStack.add(new ListType(arrayList));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public class Exec
    implements IBinding {
        public static final String NAME = "exec";

        public Exec(Sys sys) {
        }

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            CharSequence charSequence;
            Object object;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("cmd.exe");
            arrayList.add("/c");
            for (int i = 0; i < dataStack.getNumArgs(); ++i) {
                object = (DataType)dataStack.pop();
                charSequence = null;
                if (object instanceof BooleanType) {
                    charSequence = String.valueOf(DataTypeUtil.toBool((DataType)object));
                } else if (object instanceof IntegerType) {
                    charSequence = String.valueOf(DataTypeUtil.toInt((DataType)object));
                } else if (object instanceof StringType) {
                    charSequence = DataTypeUtil.toStr((DataType)object);
                } else if (object instanceof NameType) {
                    charSequence = DataTypeUtil.toName((DataType)object);
                } else {
                    System.err.print("Sys.Exec: cannot parse type");
                    System.exit(-1);
                }
                arrayList.add((String)charSequence);
            }
            try {
                ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
                object = processBuilder.start();
                charSequence = new StringBuilder();
                Object object2 = new BufferedReader(new InputStreamReader(((Process)object).getInputStream()));
                Object object3 = null;
                while ((object3 = ((BufferedReader)object2).readLine()) != null) {
                    if (!charSequence.isEmpty()) {
                        ((StringBuilder)charSequence).append("\n");
                    }
                    ((StringBuilder)charSequence).append((String)object3);
                }
                ((BufferedReader)object2).close();
                object2 = new StringBuilder();
                object3 = new BufferedReader(new InputStreamReader(((Process)object).getErrorStream()));
                String string = null;
                while ((string = ((BufferedReader)object3).readLine()) != null) {
                    if (!object2.isEmpty()) {
                        ((StringBuilder)object2).append("\n");
                    }
                    ((StringBuilder)object2).append(string);
                }
                ((BufferedReader)object3).close();
                int n = ((Process)object).waitFor();
                dataStack.add(StringType.getInstance(((StringBuilder)object2).toString()));
                dataStack.add(StringType.getInstance(((StringBuilder)charSequence).toString()));
                dataStack.add(new IntegerType(n));
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            dataStack.add(ListType.EMPTY);
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class Exit
    implements IBinding {
        public static final String NAME = "exit";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            int n = 0;
            if (dataStack.getNumArgs() == 1) {
                n = DataTypeUtil.toInt((DataType)dataStack.pop());
            }
            System.exit(n);
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class ReadIn
    implements IBinding {
        public static final String NAME = "in";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                String string = bufferedReader.readLine();
                dataStack.push(StringType.getInstance(string));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class WriteErr
    implements IBinding {
        public static final String NAME = "err";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            for (int i = 0; i < dataStack.getNumArgs(); ++i) {
                String string = ((DataType)dataStack.pop()).toString();
                System.err.print(string);
            }
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class WriteOut
    implements IBinding {
        public static final String NAME = "out";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            for (int i = 0; i < dataStack.getNumArgs(); ++i) {
                String string = ((DataType)dataStack.pop()).toString();
                System.out.print(string);
            }
        }

        @Override
        public String getName() {
            return NAME;
        }
    }
}

