/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.sasm.binding.core;

import de.slashbinbash.sasm.binding.IBinding;
import de.slashbinbash.sasm.binding.IModule;
import de.slashbinbash.sasm.interpreter.DataStack;
import de.slashbinbash.sasm.interpreter.IInterpreter;
import de.slashbinbash.sasm.type.BooleanType;
import de.slashbinbash.sasm.type.DataType;
import de.slashbinbash.sasm.type.IntegerType;
import de.slashbinbash.sasm.type.StringType;

public class Type
implements IModule {
    public static final String NAME = "type";

    @Override
    public IBinding[] createBindings() {
        return new IBinding[]{new IsBlock(), new IsBoolean(), new IsInteger(), new IsLabel(), new IsList(), new IsSame(), new IsString(), new ToInt(), new ToString()};
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static class IsBlock
    implements IBinding {
        public static final String NAME = "isblock";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            boolean bl = ((DataType)dataStack.pop()).isBlock();
            dataStack.push(BooleanType.getInstance(bl));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class IsBoolean
    implements IBinding {
        public static final String NAME = "isbool";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            boolean bl = ((DataType)dataStack.pop()).isBoolean();
            dataStack.push(BooleanType.getInstance(bl));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class IsInteger
    implements IBinding {
        public static final String NAME = "isint";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            boolean bl = ((DataType)dataStack.pop()).isInteger();
            dataStack.push(BooleanType.getInstance(bl));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class IsLabel
    implements IBinding {
        public static final String NAME = "islabel";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            boolean bl = ((DataType)dataStack.pop()).isLabel();
            dataStack.push(BooleanType.getInstance(bl));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class IsList
    implements IBinding {
        public static final String NAME = "islist";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            boolean bl = ((DataType)dataStack.pop()).isList();
            dataStack.push(BooleanType.getInstance(bl));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class IsSame
    implements IBinding {
        public static final String NAME = "issame";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            DataType dataType = (DataType)dataStack.pop();
            DataType dataType2 = (DataType)dataStack.pop();
            boolean bl = dataType.type == dataType2.type;
            dataStack.push(BooleanType.getInstance(bl));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class IsString
    implements IBinding {
        public static final String NAME = "isstr";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            boolean bl = ((DataType)dataStack.pop()).isString();
            dataStack.push(BooleanType.getInstance(bl));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class ToInt
    implements IBinding {
        public static final String NAME = "toint";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            DataType dataType = (DataType)dataStack.pop();
            int n = 0;
            if (dataType instanceof IntegerType) {
                IntegerType integerType = (IntegerType)dataType;
                n = integerType.value;
            } else if (dataType instanceof StringType) {
                StringType stringType = (StringType)dataType;
                n = Integer.parseInt(stringType.value);
            } else {
                throw new RuntimeException();
            }
            dataStack.push(new IntegerType(n));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }

    public static class ToString
    implements IBinding {
        public static final String NAME = "tostr";

        @Override
        public void exec(IInterpreter iInterpreter, DataStack dataStack) {
            String string = ((DataType)dataStack.pop()).toString();
            dataStack.push(StringType.getInstance(string));
        }

        @Override
        public String getName() {
            return NAME;
        }
    }
}

