/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.sasm.indexer;

import de.slashbinbash.sasm.binding.IPlugin;
import de.slashbinbash.sasm.indexer.Error;
import de.slashbinbash.sasm.interpreter.Util;
import de.slashbinbash.sasm.loader.PluginLoader;
import de.slashbinbash.sasm.struct.Dictionary;
import java.io.File;

public class Indexer {
    private Dictionary<CharSequence> map = new Dictionary();

    public boolean contains(CharSequence charSequence) {
        return this.map.containsKey(charSequence);
    }

    private void err_exit(Error error, String string) {
        System.out.println("X " + Error.getString(error) + ": " + string);
        System.exit(-1);
    }

    public CharSequence get(CharSequence charSequence) {
        return (CharSequence)this.map.get(charSequence.toString());
    }

    private void parseJar(File file) {
        IPlugin iPlugin = PluginLoader.loadPluginLight(file);
        if (iPlugin == null) {
            return;
        }
        for (String string : iPlugin.getModuleNames()) {
            if (this.map.containsKey(string)) {
                this.err_exit(Error.MODULE_ALREADY_EXISTS, string + " at " + String.valueOf(this.map.get(string)));
            }
            this.map.put(string, (CharSequence)file.getAbsolutePath());
        }
    }

    private void parseSasm(File file) {
        String string = file.getName();
        if (!string.endsWith(".sasm")) {
            return;
        }
        String string2 = string.substring(0, string.length() - 5);
        if (!Util.isName(string2)) {
            this.err_exit(Error.INVALID_MODULE_NAME, string2 + " at " + file.getAbsolutePath());
        }
        if (this.map.containsKey(string2)) {
            this.err_exit(Error.MODULE_ALREADY_EXISTS, string2 + " at " + String.valueOf(this.map.get(string2)));
        }
        this.map.put(string2, (CharSequence)file.getAbsolutePath());
    }

    public void search(File file) {
        if (!file.exists()) {
            this.err_exit(Error.FILE_NOT_FOUND, file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                this.search(file2);
            }
        } else if (file.isFile()) {
            if (file.getName().endsWith(".sasm")) {
                this.parseSasm(file);
            } else if (file.getName().endsWith(".jar")) {
                this.parseJar(file);
            }
        } else {
            assert (false);
            System.exit(0);
        }
    }
}

