/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.sasm.interpreter;

public enum Error {
    CANNOT_MOV,
    CANNOT_JMP_TO_BINDING,
    EMPTY_DATA_STACK,
    INVALID_LABEL,
    PARSE_ARGS_FAILED,
    UNKNOWN_INSTRUCTION,
    UNKNOWN_LABEL,
    UNKNOWN_MODULE,
    UNKNOWN_NAME,
    INVALID_NAME,
    CANNOT_CALL,
    ALREADY_DEFINED,
    BAD_NUMBER_ARGUMENTS;


    public static String getString(Error error) {
        switch (error.ordinal()) {
            case 10: {
                return "Cannot call object";
            }
            case 0: {
                return "Cannot mov value to non-name type";
            }
            case 1: {
                return "Cannot jmp to label binding";
            }
            case 2: {
                return "Data stack is empty";
            }
            case 3: {
                return "Invalid label";
            }
            case 9: {
                return "Invalid name";
            }
            case 4: {
                return "Parsing args failed";
            }
            case 5: {
                return "Unknown instruction";
            }
            case 6: {
                return "Label not found";
            }
            case 7: {
                return "Unknown module";
            }
            case 8: {
                return "Undefined variable";
            }
            case 11: {
                return "Name is already defined";
            }
            case 12: {
                return "Unexpected number of arguments";
            }
        }
        return null;
    }
}

