/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.sasm.interpreter;

import de.slashbinbash.sasm.Context;
import de.slashbinbash.sasm.InstructionEnum;
import de.slashbinbash.sasm.interpreter.CallStack;
import de.slashbinbash.sasm.interpreter.CallStackFrame;
import de.slashbinbash.sasm.interpreter.DataStack;
import de.slashbinbash.sasm.interpreter.Error;
import de.slashbinbash.sasm.interpreter.IInterpreter;
import de.slashbinbash.sasm.interpreter.Local;
import de.slashbinbash.sasm.interpreter.LocalStack;
import de.slashbinbash.sasm.interpreter.Util;
import de.slashbinbash.sasm.model.Instruction;
import de.slashbinbash.sasm.model.Label;
import de.slashbinbash.sasm.model.Module;
import de.slashbinbash.sasm.struct.Pair;
import de.slashbinbash.sasm.struct.StringView;
import de.slashbinbash.sasm.type.BlockType;
import de.slashbinbash.sasm.type.BooleanType;
import de.slashbinbash.sasm.type.DataType;
import de.slashbinbash.sasm.type.DataTypeUtil;
import de.slashbinbash.sasm.type.IntegerType;
import de.slashbinbash.sasm.type.ListType;
import de.slashbinbash.sasm.type.SymbolType;
import java.util.ArrayList;
import java.util.List;

public class Interpreter
implements IInterpreter {
    private Context ctx = null;
    private DataStack dataStack = new DataStack();
    private CallStack callStack = new CallStack();
    private LocalStack locals = new LocalStack();
    private Local local = null;
    private Module module;
    private int codeLine = 0;

    private void doFillFromStack(List<DataType> list, int n) {
        int n2 = n - list.size();
        for (int i = 0; i < n2; ++i) {
            list.add((DataType)this.dataStack.pop());
        }
    }

    private void doPushOrAssign(List<DataType> list, DataType dataType) {
        if (list.size() == 0) {
            this.dataStack.push(dataType);
        } else if (list.size() > 0) {
            DataType dataType2 = list.get(0);
            if (dataType2.isSymbol()) {
                String string = list.get(0).toString();
                this.doSetVar(string, dataType);
            } else {
                this.dataStack.push(dataType);
            }
        } else assert (false);
    }

    private void doPushOrAssignAll(List<DataType> list, DataType dataType) {
        if (list.size() == 0) {
            this.dataStack.push(dataType);
        } else if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                DataType dataType2 = list.get(i);
                if (dataType2.isSymbol()) {
                    String string = list.get(i).toString();
                    this.doSetVar(string, dataType);
                    continue;
                }
                this.dataStack.push(dataType);
            }
        } else assert (false);
    }

    private void exit_err(Error error, String string) {
        String string2 = null;
        int n = -1;
        if (this.module != null) {
            string2 = this.module.fileName;
            n = this.module.getFileLine(this.codeLine);
        }
        System.out.println("I " + string2 + ":" + (n + 1) + ": " + Error.getString(error) + ": " + string);
        System.exit(-1);
    }

    private void execAdd(List<DataType> list) {
        this.doFillFromStack(list, 2);
        int n = DataTypeUtil.toInt(this.resolveArg(list.get(0)));
        for (int i = 1; i < list.size(); ++i) {
            n += DataTypeUtil.toInt(this.resolveArg(list.get(i)));
        }
        this.doPushOrAssign(list, new IntegerType(n));
    }

    private void execAnd(List<DataType> list) {
        this.doFillFromStack(list, 2);
        boolean bl = DataTypeUtil.toBool(this.resolveArg(list.get(0)));
        for (int i = 1; i < list.size(); ++i) {
            bl &= DataTypeUtil.toBool(this.resolveArg(list.get(i)));
        }
        this.doPushOrAssign(list, BooleanType.getInstance(bl));
    }

    private void execCall(DataStack dataStack) {
        DataType dataType = (DataType)dataStack.pop();
        --dataStack.numArgs;
        if (dataType.isBlock()) {
            this.execCallBlock((BlockType)dataType);
        } else if (dataType.isSymbol()) {
            this.execCallLabel(((SymbolType)dataType).value);
        } else {
            this.exit_err(Error.CANNOT_CALL, dataType.type.name());
        }
    }

    private void execCallBlock(BlockType blockType) {
        List<Instruction> list = this.ctx.parser.parseLine(blockType.value.toString());
        for (Instruction instruction : list) {
            this.execInstruction(instruction);
        }
    }

    private void execCallLabel(String string) {
        Pair<Module, Label> pair = this.resolveLabel(string, this.codeLine);
        Module module = (Module)pair.a;
        Label label = (Label)pair.b;
        if (label.binding != null) {
            label.binding.exec(this, this.dataStack);
        } else {
            this.callStack.push(this.module, this.codeLine);
            this.local = this.locals.push(new Local());
            this.module = module;
            this.codeLine = label.codeLine - 1;
        }
    }

    private void execCmp(List<DataType> list) {
        if (list.size() > 2) {
            this.exit_err(Error.BAD_NUMBER_ARGUMENTS, "cmp takes 2 arguments");
        }
        this.doFillFromStack(list, 2);
        DataType dataType = this.resolveArg(list.get(0));
        DataType dataType2 = this.resolveArg(list.get(1));
        this.local.cmpFlag = dataType.compareTo(dataType2);
    }

    private void execDec(List<DataType> list) {
        this.doFillFromStack(list, 1);
        for (int i = 0; i < list.size(); ++i) {
            int n = DataTypeUtil.toInt(this.resolveArg(list.get(i))) - 1;
            IntegerType integerType = new IntegerType(n);
            DataType dataType = list.get(i);
            if (dataType.isSymbol()) {
                String string = list.get(i).toString();
                this.doSetVar(string, integerType);
                continue;
            }
            this.dataStack.push(integerType);
        }
    }

    private void execDiv(List<DataType> list) {
        this.doFillFromStack(list, 2);
        int n = DataTypeUtil.toInt(this.resolveArg(list.get(0)));
        for (int i = 1; i < list.size(); ++i) {
            n /= DataTypeUtil.toInt(this.resolveArg(list.get(i)));
        }
        this.doPushOrAssign(list, new IntegerType(n));
    }

    private void execInc(List<DataType> list) {
        this.doFillFromStack(list, 1);
        for (int i = 0; i < list.size(); ++i) {
            int n = DataTypeUtil.toInt(this.resolveArg(list.get(i))) + 1;
            IntegerType integerType = new IntegerType(n);
            DataType dataType = list.get(i);
            if (dataType.isSymbol()) {
                String string = list.get(i).toString();
                this.doSetVar(string, integerType);
                continue;
            }
            this.dataStack.push(integerType);
        }
    }

    private void execInstruction(Instruction instruction) {
        ArrayList<DataType> arrayList = new ArrayList<DataType>();
        String string = null;
        InstructionEnum instructionEnum = null;
        string = instruction.instruction;
        boolean bl = Util.isName(string);
        if (instructionEnum == null && bl) {
            instructionEnum = Util.getInstruction(string);
        }
        if (instructionEnum == null && bl && this.ctx.definitions.containsKey(string)) {
            arrayList.add(SymbolType.getInstance(this.ctx.definitions.get(string)));
            string = null;
            instructionEnum = InstructionEnum.call;
        }
        if (instructionEnum == null && Util.isLabel(string)) {
            arrayList.add(SymbolType.getInstance(string));
            string = null;
            instructionEnum = InstructionEnum.call;
        }
        if (instructionEnum == null) {
            this.exit_err(Error.UNKNOWN_INSTRUCTION, string.toString());
        }
        arrayList.addAll(instruction.args);
        if (!(instructionEnum != InstructionEnum.call && instructionEnum != InstructionEnum.ret && instructionEnum != InstructionEnum.push || arrayList.isEmpty())) {
            this.resolveSymbols(arrayList);
            this.dataStack.numArgs = arrayList.size();
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                this.dataStack.push((DataType)arrayList.get(i));
            }
        }
        switch (instructionEnum) {
            case call: {
                this.execCall(this.dataStack);
                break;
            }
            case jmp: {
                this.execJmp(arrayList);
                break;
            }
            case mov: {
                this.execMov(arrayList);
                break;
            }
            case pop: {
                this.execPop(arrayList);
                break;
            }
            case push: {
                break;
            }
            case ret: {
                this.execRet(this.dataStack);
                break;
            }
            case defer: {
                Instruction instruction2 = new Instruction();
                instruction2.instruction = "call";
                instruction2.args = instruction.args;
                instruction2.codeLine = instruction.codeLine;
                instruction2.fileLine = instruction.fileLine;
                this.local.defers.push(instruction2);
                break;
            }
            case add: {
                this.execAdd(arrayList);
                break;
            }
            case sub: {
                this.execSub(arrayList);
                break;
            }
            case mul: {
                this.execMul(arrayList);
                break;
            }
            case div: {
                this.execDiv(arrayList);
                break;
            }
            case mod: {
                this.execMod(arrayList);
                break;
            }
            case inc: {
                this.execInc(arrayList);
                break;
            }
            case dec: {
                this.execDec(arrayList);
                break;
            }
            case and: {
                this.execAnd(arrayList);
                break;
            }
            case or: {
                this.execOr(arrayList);
                break;
            }
            case xor: {
                this.execXor(arrayList);
                break;
            }
            case not: {
                this.execNot(arrayList);
                break;
            }
            case cmp: {
                this.execCmp(arrayList);
                break;
            }
            case sete: {
                this.execSete(arrayList);
                break;
            }
            case setne: {
                this.execSetne(arrayList);
                break;
            }
            case setl: {
                this.execSetl(arrayList);
                break;
            }
            case setle: {
                this.execSetle(arrayList);
                break;
            }
            case setg: {
                this.execSetg(arrayList);
                break;
            }
            case setge: {
                this.execSetge(arrayList);
                break;
            }
            case je: {
                this.execJe(arrayList);
                break;
            }
            case jg: {
                this.execJg(arrayList);
                break;
            }
            case jge: {
                this.execJge(arrayList);
                break;
            }
            case jl: {
                this.execJl(arrayList);
                break;
            }
            case jle: {
                this.execJle(arrayList);
                break;
            }
            case jne: {
                this.execJne(arrayList);
                break;
            }
            default: {
                assert (false) : "Unknown instruction: " + String.valueOf((Object)instructionEnum);
                System.exit(0);
            }
        }
    }

    private void execJe(List<DataType> list) {
        assert (list.size() == 1);
        if (this.local.cmpFlag == 0) {
            this.execJmp(list);
        }
    }

    private void execJg(List<DataType> list) {
        assert (list.size() == 1);
        if (this.local.cmpFlag > 0) {
            this.execJmp(list);
        }
    }

    private void execJge(List<DataType> list) {
        assert (list.size() == 1);
        if (this.local.cmpFlag >= 0) {
            this.execJmp(list);
        }
    }

    private void execJl(List<DataType> list) {
        assert (list.size() == 1);
        if (this.local.cmpFlag < 0) {
            this.execJmp(list);
        }
    }

    private void execJle(List<DataType> list) {
        assert (list.size() == 1);
        if (this.local.cmpFlag <= 0) {
            this.execJmp(list);
        }
    }

    private void execJmp(List<DataType> list) {
        assert (list.size() == 1);
        DataType dataType = list.get(0);
        if (!dataType.isSymbol()) {
            this.exit_err(Error.INVALID_LABEL, "Invalid label: " + dataType.toString());
        }
        String string = ((SymbolType)dataType).value;
        Pair<Module, Label> pair = this.resolveLabel(string, this.codeLine);
        Module module = (Module)pair.a;
        Label label = (Label)pair.b;
        if (label.binding != null) {
            this.exit_err(Error.CANNOT_JMP_TO_BINDING, module.name + "." + label.name);
        }
        this.module = module;
        this.codeLine = label.codeLine - 1;
    }

    private void execJne(List<DataType> list) {
        assert (list.size() == 1);
        if (this.local.cmpFlag != 0) {
            this.execJmp(list);
        }
    }

    private void execMod(List<DataType> list) {
        this.doFillFromStack(list, 2);
        int n = DataTypeUtil.toInt(this.resolveArg(list.get(0)));
        for (int i = 1; i < list.size(); ++i) {
            n %= DataTypeUtil.toInt(this.resolveArg(list.get(i)));
        }
        this.doPushOrAssign(list, new IntegerType(n));
    }

    private void execMov(List<DataType> list) {
        if (list.size() == 0 || list.size() > 2) {
            this.exit_err(Error.BAD_NUMBER_ARGUMENTS, "mov takes 1 or 2 arguments");
        }
        if (list.size() == 1) {
            list.add((DataType)this.dataStack.pop());
        }
        assert (list.size() == 2);
        DataType dataType = list.get(0);
        DataType dataType2 = list.get(1);
        if (dataType.isSymbol()) {
            String string = dataType.toString();
            this.doSetVar(string, this.resolveArg(dataType2));
        } else assert (false);
    }

    private void execMul(List<DataType> list) {
        this.doFillFromStack(list, 2);
        int n = DataTypeUtil.toInt(this.resolveArg(list.get(0)));
        for (int i = 1; i < list.size(); ++i) {
            n *= DataTypeUtil.toInt(this.resolveArg(list.get(i)));
        }
        this.doPushOrAssign(list, new IntegerType(n));
    }

    private void execNot(List<DataType> list) {
        this.doFillFromStack(list, 1);
        boolean bl = !DataTypeUtil.toBool(this.resolveArg(list.get(0)));
        this.doPushOrAssign(list, BooleanType.getInstance(bl));
    }

    private void execOr(List<DataType> list) {
        this.doFillFromStack(list, 2);
        boolean bl = DataTypeUtil.toBool(this.resolveArg(list.get(0)));
        for (int i = 1; i < list.size(); ++i) {
            bl |= DataTypeUtil.toBool(this.resolveArg(list.get(i)));
        }
        this.doPushOrAssign(list, BooleanType.getInstance(bl));
    }

    private void doSetVar(String string, DataType dataType) {
        if (Util.getInstruction(string) != null) {
            this.exit_err(Error.ALREADY_DEFINED, string);
        }
        if (this.ctx.definitions.containsKey(string)) {
            this.exit_err(Error.ALREADY_DEFINED, string);
        }
        if (this.module.labelMap.containsKey(string)) {
            this.exit_err(Error.ALREADY_DEFINED, string);
        }
        this.local.vars.put(string, dataType);
    }

    private void execPop(List<DataType> list) {
        if (list.size() == 0) {
            this.dataStack.pop();
        } else {
            for (DataType dataType : list) {
                if (dataType.isSymbol()) {
                    String string = dataType.toString();
                    DataType dataType2 = (DataType)this.dataStack.pop();
                    this.doSetVar(string, dataType2);
                    continue;
                }
                if (dataType.isStack()) {
                    this.dataStack.pop();
                    continue;
                }
                assert (false);
            }
        }
    }

    private void execRet(DataStack dataStack) {
        while (!this.local.defers.isEmpty()) {
            this.execInstruction(this.local.defers.pop());
        }
        CallStackFrame callStackFrame = (CallStackFrame)this.callStack.pop();
        this.module = callStackFrame.module;
        this.codeLine = callStackFrame.codeLine;
        this.locals.pop();
        this.local = !this.locals.isEmpty() ? (Local)this.locals.peek() : null;
        callStackFrame.clear();
    }

    @Override
    public void execRun() {
        this.execRun(this.dataStack);
    }

    private void execRun(DataStack dataStack) {
        this.callStack.rebaseUp();
        this.execCall(dataStack);
        this.run();
        this.callStack.rebaseDown();
    }

    private void execSete(List<DataType> list) {
        boolean bl = this.local.cmpFlag == 0;
        this.doPushOrAssignAll(list, BooleanType.getInstance(bl));
    }

    private void execSetg(List<DataType> list) {
        boolean bl = this.local.cmpFlag > 0;
        this.doPushOrAssignAll(list, BooleanType.getInstance(bl));
    }

    private void execSetge(List<DataType> list) {
        boolean bl = this.local.cmpFlag >= 0;
        this.doPushOrAssignAll(list, BooleanType.getInstance(bl));
    }

    private void execSetl(List<DataType> list) {
        boolean bl = this.local.cmpFlag < 0;
        this.doPushOrAssignAll(list, BooleanType.getInstance(bl));
    }

    private void execSetle(List<DataType> list) {
        boolean bl = this.local.cmpFlag <= 0;
        this.doPushOrAssignAll(list, BooleanType.getInstance(bl));
    }

    private void execSetne(List<DataType> list) {
        boolean bl = this.local.cmpFlag != 0;
        this.doPushOrAssignAll(list, BooleanType.getInstance(bl));
    }

    private void execSub(List<DataType> list) {
        this.doFillFromStack(list, 2);
        int n = DataTypeUtil.toInt(this.resolveArg(list.get(0)));
        for (int i = 1; i < list.size(); ++i) {
            n -= DataTypeUtil.toInt(this.resolveArg(list.get(i)));
        }
        this.doPushOrAssign(list, new IntegerType(n));
    }

    private void execXor(List<DataType> list) {
        this.doFillFromStack(list, 2);
        boolean bl = DataTypeUtil.toBool(this.resolveArg(list.get(0)));
        for (int i = 1; i < list.size(); ++i) {
            bl ^= DataTypeUtil.toBool(this.resolveArg(list.get(i)));
        }
        this.doPushOrAssign(list, BooleanType.getInstance(bl));
    }

    public DataStack getDataStack() {
        return this.dataStack;
    }

    private DataType resolveArg(DataType dataType) {
        return this.resolveSymbol(dataType);
    }

    private Pair<Module, Label> resolveLabel(String string, int n) {
        Module module = null;
        Label label = null;
        int n2 = string.indexOf(46);
        if (n2 > 0) {
            ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
            StringView.split(string, '.', arrayList);
            CharSequence charSequence = (CharSequence)arrayList.get(0);
            CharSequence charSequence2 = (CharSequence)arrayList.get(1);
            module = this.module != null && charSequence.equals(this.module.name) ? this.module : this.ctx.moduleLoader.load(charSequence, charSequence2);
            if (!module.labelMap.containsKey(charSequence2)) {
                this.exit_err(Error.UNKNOWN_LABEL, String.valueOf(charSequence) + "." + String.valueOf(charSequence2));
            }
            label = module.labelMap.get(charSequence2);
        } else if (n2 == 0) {
            String string2 = string;
            if (!this.module.labelMap.containsKey(string2)) {
                this.exit_err(Error.UNKNOWN_LABEL, String.valueOf(string2));
            }
            module = this.module;
            label = this.module.labelMap.get(string2);
        } else {
            String string3 = string;
            char c = string3.charAt(0);
            if (Util.isAlpha(c)) {
                if (!this.module.labelMap.containsKey(string3)) {
                    this.exit_err(Error.UNKNOWN_LABEL, String.valueOf(string3));
                }
                module = this.module;
                label = this.module.labelMap.get(string3);
            } else {
                this.exit_err(Error.UNKNOWN_LABEL, String.valueOf(string3));
            }
        }
        if (module == null || label == null) {
            this.exit_err(Error.UNKNOWN_LABEL, string);
        }
        assert (module != null);
        assert (label != null);
        return new Pair<Module, Label>(module, label);
    }

    private DataType resolveSymbol(DataType dataType) {
        Object object;
        if (dataType.isStack()) {
            return (DataType)this.dataStack.pop();
        }
        if (dataType.isSymbol()) {
            object = dataType.toString();
            if (this.local.vars.containsKey(object)) {
                return (DataType)this.local.vars.get(object);
            }
            if (this.module.labelMap.containsKey(object)) {
                return dataType;
            }
            if (Util.isPublicLabelFull((CharSequence)object)) {
                return dataType;
            }
            if (Util.isPrivateLabel((CharSequence)object)) {
                return dataType;
            }
            if (Util.isPrivateNumericLabel((CharSequence)object)) {
                return dataType;
            }
            this.exit_err(Error.UNKNOWN_NAME, dataType.toString());
        }
        if (dataType instanceof ListType) {
            object = (ListType)dataType;
            return this.resolveSymbol((ListType)object);
        }
        return dataType;
    }

    private DataType resolveSymbol(ListType listType) {
        if (listType.isConstant()) {
            listType = new ListType(listType);
        }
        for (int i = 0; i < listType.size(); ++i) {
            DataType dataType = listType.get(i);
            DataType dataType2 = this.resolveSymbol(dataType);
            if (dataType2 != null) {
                listType.set(i, dataType2);
                continue;
            }
            this.exit_err(Error.UNKNOWN_NAME, "");
        }
        return listType;
    }

    private void resolveSymbols(List<DataType> list) {
        for (int i = 0; i < list.size(); ++i) {
            DataType dataType = list.get(i);
            DataType dataType2 = this.resolveSymbol(dataType);
            if (dataType2 != null) {
                list.set(i, dataType2);
                continue;
            }
            this.exit_err(Error.UNKNOWN_NAME, "");
        }
    }

    private void run() {
        while (!this.callStack.isEmpty()) {
            ++this.codeLine;
            this.execInstruction(this.module.instructions.get(this.codeLine));
        }
    }

    public void setContext(Context context) {
        this.ctx = context;
    }
}

