/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.sasm.interpreter;

import de.slashbinbash.sasm.InstructionEnum;
import de.slashbinbash.sasm.interpreter.Error;
import de.slashbinbash.sasm.type.BlockType;
import de.slashbinbash.sasm.type.BooleanType;
import de.slashbinbash.sasm.type.DataType;
import de.slashbinbash.sasm.type.IntegerType;
import de.slashbinbash.sasm.type.ListType;
import de.slashbinbash.sasm.type.NameType;
import de.slashbinbash.sasm.type.StackType;
import de.slashbinbash.sasm.type.StringType;
import de.slashbinbash.sasm.type.SymbolType;
import de.slashbinbash.sasm.type.WildcardType;
import java.util.ArrayList;
import java.util.List;

public class Util {
    public static final Err err = new Err();

    public static String clean(CharSequence charSequence) {
        StringBuffer stringBuffer = new StringBuffer();
        State state = State.PRE_INSTRUCTION;
        block7: for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            switch (state.ordinal()) {
                case 1: {
                    if (c == ' ' || c == '\t') continue block7;
                    if (Util.isAlpha(c) || c == '_') {
                        stringBuffer.append(c);
                        state = State.INSTRUCTION;
                        continue block7;
                    }
                    if (c == ';') {
                        i = charSequence.length();
                        continue block7;
                    }
                    stringBuffer.append(c);
                    continue block7;
                }
                case 2: {
                    if (c == ' ' || c == '\t') {
                        state = State.POST_INSTRUCTION;
                        continue block7;
                    }
                    if (c == ';') {
                        i = charSequence.length();
                        continue block7;
                    }
                    stringBuffer.append(c);
                    continue block7;
                }
                case 3: {
                    if (c == ' ' || c == '\t') continue block7;
                    if (c != ';' && c != '|') {
                        stringBuffer.append(" ");
                    }
                    --i;
                    state = State.DEFAULT;
                    continue block7;
                }
                case 4: {
                    if (c == '\"' && charSequence.charAt(i - 1) != '\\') {
                        stringBuffer.append("\"");
                        state = State.DEFAULT;
                        continue block7;
                    }
                    stringBuffer.append(c);
                    continue block7;
                }
                case 5: {
                    if (c == '}') {
                        stringBuffer.append(c);
                        state = State.DEFAULT;
                        continue block7;
                    }
                    stringBuffer.append(c);
                    continue block7;
                }
                default: {
                    if (c == ' ' || c == '\t') continue block7;
                    if (c == '|') {
                        stringBuffer.append(c);
                        state = State.PRE_INSTRUCTION;
                        continue block7;
                    }
                    if (c == ';') {
                        i = charSequence.length();
                        continue block7;
                    }
                    if (c == '\"') {
                        stringBuffer.append("\"");
                        state = State.STRING;
                        continue block7;
                    }
                    if (c == '{') {
                        stringBuffer.append("{");
                        state = State.BLOCK;
                        continue block7;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String cleanArgs(CharSequence charSequence) {
        StringBuffer stringBuffer = new StringBuffer();
        State state = State.DEFAULT;
        block3: for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            switch (state.ordinal()) {
                case 4: {
                    if (c == '\"' && charSequence.charAt(i - 1) != '\\') {
                        stringBuffer.append("\"");
                        state = State.DEFAULT;
                        continue block3;
                    }
                    stringBuffer.append(c);
                    continue block3;
                }
                default: {
                    if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue block3;
                    if (c == '\"') {
                        stringBuffer.append("\"");
                        state = State.STRING;
                        continue block3;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String escape(String string) {
        return string.replace("\t", "\\t").replace("\n", "\\n");
    }

    public static int findClosingBracket(CharSequence charSequence, CharSequence charSequence2, int n) {
        char c = charSequence.charAt(0);
        char c2 = charSequence.charAt(1);
        int n2 = n;
        boolean bl = false;
        int n3 = 0;
        while (true) {
            if (++n2 >= charSequence2.length()) {
                return -1;
            }
            char c3 = charSequence2.charAt(n2);
            if (bl) {
                assert (n2 > 0);
                if (c3 != '\"' || charSequence2.charAt(n2 - 1) == '\\') continue;
                bl = false;
                continue;
            }
            if (c3 == c) {
                ++n3;
            }
            if (c3 == c2) {
                if (n3 == 0) break;
                --n3;
            }
            if (c3 != '\"') continue;
            bl = true;
        }
        if (n3 != 0) {
            return -1;
        }
        return n2;
    }

    public static int findStringEnd(CharSequence charSequence, int n) {
        for (int i = n + 1; i < charSequence.length(); ++i) {
            if (charSequence.charAt(i) != '\"' || charSequence.charAt(i - 1) == '\\') continue;
            return i;
        }
        return -1;
    }

    public static InstructionEnum getInstruction(CharSequence charSequence) {
        InstructionEnum[] instructionEnumArray = InstructionEnum.values();
        for (int i = 0; i < instructionEnumArray.length; ++i) {
            if (!charSequence.equals(instructionEnumArray[i].name())) continue;
            return instructionEnumArray[i];
        }
        return null;
    }

    public static int indexOf(CharSequence charSequence, char c) {
        return Util.indexOf(charSequence, c, 0);
    }

    public static int indexOf(CharSequence charSequence, char c, int n) {
        for (int i = n; i < charSequence.length(); ++i) {
            if (charSequence.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static boolean isAlpha(char c) {
        return 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z';
    }

    public static boolean isAlphaNumeric(char c) {
        return Util.isAlpha(c) || Util.isNumeric(c);
    }

    public static boolean isBoolean(CharSequence charSequence) {
        return charSequence.equals("true") || charSequence.equals("false");
    }

    public static boolean isEmpty(CharSequence charSequence) {
        return charSequence.length() == 0;
    }

    public static boolean isHex(char c) {
        return Util.isNumeric(c) || 'A' <= c && c <= 'F' || 'a' <= c && c <= 'f';
    }

    public static boolean isHexNumber(CharSequence charSequence) {
        if (charSequence.length() < 3) {
            return false;
        }
        if (charSequence.charAt(0) != '0' || charSequence.charAt(1) != 'x') {
            return false;
        }
        for (int i = 2; i < charSequence.length(); ++i) {
            if (Util.isHex(charSequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isInteger(CharSequence charSequence) {
        char c = charSequence.charAt(0);
        if (c == '-') {
            if (charSequence.length() == 1) {
                return false;
            }
            for (int i = 1; i < charSequence.length(); ++i) {
                c = charSequence.charAt(i);
                if (Util.isNumeric(c)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < charSequence.length(); ++i) {
                c = charSequence.charAt(i);
                if (Util.isNumeric(c)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isLabel(CharSequence charSequence) {
        return Util.isPublicLabel(charSequence) || Util.isPublicLabelFull(charSequence) || Util.isPrivateLabel(charSequence) || Util.isPrivateNumericLabel(charSequence);
    }

    public static boolean isLabelDef(CharSequence charSequence) {
        return Util.isPublicLabelDef(charSequence) || Util.isPrivateLabelDef(charSequence) || Util.isPrivateNumericLabelDef(charSequence);
    }

    public static boolean isName(CharSequence charSequence) {
        boolean bl;
        if (charSequence.length() == 0) {
            return false;
        }
        char c = charSequence.charAt(0);
        boolean bl2 = Util.isAlpha(c);
        boolean bl3 = bl = c == '_' && charSequence.length() > 1;
        if (!bl2 && !bl) {
            return false;
        }
        for (int i = 1; i < charSequence.length(); ++i) {
            c = charSequence.charAt(i);
            if (Util.isAlphaNumeric(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(CharSequence charSequence) {
        return Util.isInteger(charSequence) || Util.isHexNumber(charSequence);
    }

    public static boolean isNumeric(char c) {
        return '0' <= c && c <= '9';
    }

    public static boolean isPair(CharSequence charSequence) {
        if (Util.isEmpty(charSequence)) {
            return false;
        }
        return Util.splitAtChar(charSequence, ':', null) == 2;
    }

    public static boolean isPrivateLabel(CharSequence charSequence) {
        if (Util.isEmpty(charSequence)) {
            return false;
        }
        if (charSequence.charAt(0) != '.') {
            return false;
        }
        return Util.isName(charSequence.subSequence(1, charSequence.length()));
    }

    public static boolean isPrivateLabelDef(CharSequence charSequence) {
        if (charSequence.length() <= 1) {
            return false;
        }
        if (charSequence.charAt(charSequence.length() - 1) != ':') {
            return false;
        }
        if (charSequence.charAt(0) != '.') {
            return false;
        }
        return Util.isName(charSequence.subSequence(1, charSequence.length() - 1));
    }

    public static boolean isPrivateNumericLabel(CharSequence charSequence) {
        int n;
        if (Util.isEmpty(charSequence)) {
            return false;
        }
        if (charSequence.length() <= 1) {
            return false;
        }
        for (n = 0; n < charSequence.length() - 1; ++n) {
            char c = charSequence.charAt(n);
            if (Util.isNumeric(c)) continue;
            return false;
        }
        n = charSequence.charAt(charSequence.length() - 1);
        return n == 98 || n == 102;
    }

    public static boolean isPrivateNumericLabelDef(CharSequence charSequence) {
        if (charSequence.length() <= 1) {
            return false;
        }
        if (charSequence.charAt(charSequence.length() - 1) != ':') {
            return false;
        }
        for (int i = 0; i < charSequence.length() - 1; ++i) {
            char c = charSequence.charAt(i);
            if (Util.isNumeric(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPublicLabel(CharSequence charSequence) {
        if (Util.isEmpty(charSequence)) {
            return false;
        }
        return Util.isName(charSequence.subSequence(0, charSequence.length()));
    }

    public static boolean isPublicLabelDef(CharSequence charSequence) {
        if (charSequence.length() <= 1) {
            return false;
        }
        if (charSequence.charAt(charSequence.length() - 1) != ':') {
            return false;
        }
        return Util.isName(charSequence.subSequence(0, charSequence.length() - 1));
    }

    public static boolean isPublicLabelFull(CharSequence charSequence) {
        if (Util.isEmpty(charSequence)) {
            return false;
        }
        if (Util.indexOf(charSequence, '.') == -1) {
            return false;
        }
        int n = Util.indexOf(charSequence, '.');
        CharSequence charSequence2 = charSequence.subSequence(0, n);
        CharSequence charSequence3 = charSequence.subSequence(n + 1, charSequence.length());
        return Util.isName(charSequence2) && Util.isName(charSequence3);
    }

    public static boolean isStack(CharSequence charSequence) {
        return charSequence.equals("_");
    }

    public static boolean isVariable(CharSequence charSequence) {
        return Util.isName(charSequence);
    }

    public static boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t';
    }

    public static DataType parseArg(CharSequence charSequence) {
        err.clear();
        char c = charSequence.charAt(0);
        if (Util.isNumeric(c) || c == '-') {
            if (Util.isInteger(charSequence)) {
                int n = Integer.parseInt(charSequence.toString());
                return new IntegerType(n);
            }
            if (Util.isHexNumber(charSequence)) {
                int n = Integer.decode(charSequence.toString());
                return new IntegerType(n);
            }
        } else if (Util.isAlpha(c)) {
            if (Util.isBoolean(charSequence)) {
                return BooleanType.getInstance(Util.toBoolean(charSequence));
            }
        } else if (c == '_') {
            if (Util.isStack(charSequence)) {
                return StackType.INSTANCE;
            }
        } else {
            if (c == '\"') {
                CharSequence charSequence2 = charSequence.subSequence(1, charSequence.length() - 1);
                String string = charSequence2.toString();
                string = string.replace("\\n", "\n");
                string = string.replace("\\r", "\r");
                string = string.replace("\\\"", "\"");
                return StringType.getInstance(string);
            }
            if (c == '[') {
                if (charSequence.charAt(1) == ']') {
                    return ListType.EMPTY;
                }
                ArrayList<DataType> arrayList = new ArrayList<DataType>(0);
                if (Util.parseArgs(charSequence.subSequence(1, charSequence.length() - 1), arrayList) < 1) {
                    return null;
                }
                DataType[] dataTypeArray = new DataType[arrayList.size()];
                arrayList.toArray(dataTypeArray);
                return new ListType(dataTypeArray);
            }
            if (c == '{') {
                CharSequence charSequence3 = charSequence.subSequence(1, charSequence.length() - 1);
                return new BlockType(charSequence3.toString());
            }
            if (c == '*') {
                return WildcardType.INSTANCE;
            }
            if (c == '/') {
                CharSequence charSequence4 = charSequence.subSequence(1, charSequence.length());
                if (Util.isName(charSequence4)) {
                    return NameType.getInstance(charSequence4.toString());
                }
                Util.err.id = Error.INVALID_NAME;
                Util.err.str = charSequence.toString();
                return null;
            }
        }
        return SymbolType.getInstance(charSequence);
    }

    public static int parseArgs(CharSequence charSequence, List<DataType> list) {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        if (Util.splitAtChar(charSequence, ',', arrayList) > 0) {
            for (CharSequence charSequence2 : arrayList) {
                DataType dataType = Util.parseArg(charSequence2);
                if (dataType == null) {
                    return -1;
                }
                list.add(dataType);
            }
        }
        return list.size();
    }

    private static int splitAtChar(CharSequence charSequence, char c, List<CharSequence> list) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        block5: for (n = 0; n < charSequence.length(); ++n) {
            char c2 = charSequence.charAt(n);
            switch (c2) {
                case '{': {
                    n4 = Util.findClosingBracket("{}", charSequence, n);
                    if (n4 == -1) {
                        return -1;
                    }
                    n = n4;
                    continue block5;
                }
                case '[': {
                    n4 = Util.findClosingBracket("[]", charSequence, n);
                    if (n4 == -1) {
                        return -1;
                    }
                    n = n4;
                    continue block5;
                }
                case '\"': {
                    n4 = Util.findStringEnd(charSequence, n);
                    if (n4 == -1) {
                        return -1;
                    }
                    n = n4;
                    continue block5;
                }
                default: {
                    if (c2 != c) continue block5;
                    if (n3 != n) {
                        if (list != null) {
                            list.add(charSequence.subSequence(n3, n));
                        }
                        ++n2;
                    }
                    n3 = n + 1;
                }
            }
        }
        if (n3 != n) {
            if (list != null) {
                list.add(charSequence.subSequence(n3, n));
            }
            ++n2;
        }
        assert (list == null || list.size() == n2);
        return n2;
    }

    public static int splitPipe(CharSequence charSequence, List<CharSequence> list) {
        return Util.splitAtChar(charSequence, '|', list);
    }

    public static boolean toBoolean(CharSequence charSequence) {
        if (charSequence.equals("true")) {
            return true;
        }
        if (charSequence.equals("false")) {
            return false;
        }
        assert (false);
        System.exit(1);
        return false;
    }

    public static String unescape(String string) {
        return string.replace("\\\"", "\"");
    }

    public static boolean writeArgs(DataType dataType, StringBuilder stringBuilder) {
        if (dataType.isBoolean()) {
            stringBuilder.append(dataType.toString());
            return true;
        }
        if (dataType.isInteger()) {
            stringBuilder.append(dataType.toString());
            return true;
        }
        if (dataType.isList()) {
            return Util.writeArgs((ListType)dataType, stringBuilder);
        }
        if (dataType.isString()) {
            return Util.writeArgs((StringType)dataType, stringBuilder);
        }
        stringBuilder.append(dataType.toString());
        return false;
    }

    private static boolean writeArgs(ListType listType, StringBuilder stringBuilder) {
        boolean bl = true;
        stringBuilder.append("[");
        for (int i = 0; i < listType.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            bl &= Util.writeArgs(listType.get(i), stringBuilder);
        }
        stringBuilder.append("]");
        return bl;
    }

    private static boolean writeArgs(StringType stringType, StringBuilder stringBuilder) {
        stringBuilder.append("\"");
        stringBuilder.append(Util.escape(stringType.value));
        stringBuilder.append("\"");
        return true;
    }

    private static enum State {
        DEFAULT,
        PRE_INSTRUCTION,
        INSTRUCTION,
        POST_INSTRUCTION,
        STRING,
        BLOCK;

    }

    public static class Err {
        public Error id = null;
        public String str = null;

        public void clear() {
            this.id = null;
            this.str = null;
        }
    }
}

