/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.sasm.loader;

import de.slashbinbash.sasm.Context;
import de.slashbinbash.sasm.binding.IBinding;
import de.slashbinbash.sasm.binding.IModule;
import de.slashbinbash.sasm.binding.IPlugin;
import de.slashbinbash.sasm.interpreter.Error;
import de.slashbinbash.sasm.model.Label;
import de.slashbinbash.sasm.model.Module;
import de.slashbinbash.sasm.struct.Dictionary;
import java.io.File;

public class ModuleLoader {
    private Context context;
    private Dictionary<Module> modules = new Dictionary();

    public void addModule(IModule iModule) {
        assert (!this.modules.containsKey(iModule.getName()));
        Module module = this.createModule(iModule);
        this.modules.put(module.name, module);
    }

    public void addModule(Module module) {
        this.modules.put(module.name, module);
    }

    private Module createModule(IModule iModule) {
        IBinding[] iBindingArray;
        Module module = new Module();
        module.fileName = null;
        module.name = iModule.getName();
        for (IBinding iBinding : iBindingArray = iModule.createBindings()) {
            Label label = new Label(module.name, iBinding.getName(), iBinding);
            module.labels.add(label);
            module.labelMap.put(label.name, label);
        }
        return module;
    }

    private void err_exit(Error error, String string) {
        System.out.println(Error.getString(error) + ": " + string);
        System.exit(-1);
    }

    public Module load(CharSequence charSequence, CharSequence charSequence2) {
        File file;
        if (this.modules.containsKey(charSequence)) {
            return this.modules.get(charSequence);
        }
        if (!this.context.indexer.contains(charSequence)) {
            this.err_exit(Error.UNKNOWN_MODULE, charSequence.toString());
            System.exit(0);
        }
        if ((file = new File(this.context.indexer.get(charSequence).toString())).getAbsolutePath().endsWith(".sasm")) {
            Module module = this.context.parser.parseFile(file);
            module.name = charSequence.toString();
            this.modules.put(charSequence, module);
            return module;
        }
        if (file.getAbsolutePath().endsWith(".jar")) {
            IPlugin iPlugin = this.context.pluginLoader.loadPlugin(file);
            Module module = this.createModule(iPlugin.getModule(charSequence.toString()));
            this.modules.put(charSequence, module);
            return module;
        }
        assert (false);
        this.err_exit(Error.UNKNOWN_MODULE, charSequence.toString());
        return null;
    }

    public void setContext(Context context) {
        this.context = context;
    }
}

