/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.sasm.loader;

import de.slashbinbash.sasm.binding.IPlugin;
import de.slashbinbash.sasm.loader.Plugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;

public class PluginLoader {
    private HashMap<String, IPlugin> iplugins = new HashMap();

    public static Plugin createPlugin(File file) {
        Plugin plugin = new Plugin();
        plugin.file = file;
        try {
            URL[] uRLArray = new URL[]{file.toURI().toURL()};
            URLClassLoader uRLClassLoader = URLClassLoader.newInstance(uRLArray);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLClassLoader.getResourceAsStream("config")));
            plugin.entryClass = bufferedReader.readLine();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return plugin;
    }

    public static IPlugin loadPluginLight(File file) {
        try {
            URLClassLoader uRLClassLoader = URLClassLoader.newInstance(new URL[]{file.toURI().toURL()});
            InputStream inputStream = uRLClassLoader.getResourceAsStream("config");
            if (inputStream == null) {
                return null;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            bufferedReader.close();
            return (IPlugin)Class.forName(string, true, uRLClassLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        return null;
    }

    public IPlugin loadPlugin(File file) {
        String string = file.getAbsolutePath();
        IPlugin iPlugin = null;
        if (this.iplugins.containsKey(string)) {
            iPlugin = this.iplugins.get(string);
        } else {
            iPlugin = PluginLoader.createPlugin(file).newInstance();
            assert (iPlugin != null);
            this.iplugins.put(string, iPlugin);
        }
        return iPlugin;
    }
}

