/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.sasm.parser;

import de.slashbinbash.sasm.interpreter.Util;
import de.slashbinbash.sasm.model.Instruction;
import de.slashbinbash.sasm.model.Label;
import de.slashbinbash.sasm.model.Module;
import de.slashbinbash.sasm.struct.Dictionary;
import de.slashbinbash.sasm.type.DataType;
import de.slashbinbash.sasm.type.SymbolType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class Parser {
    private boolean hasValue(String string, List<Label> list) {
        for (Label label : list) {
            if (!label.name.equals(string)) continue;
            return true;
        }
        return false;
    }

    public void parseBuffer(BufferedReader bufferedReader, Module module) throws IOException {
        String string;
        int n = 0;
        int n2 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            Object object;
            Object object2;
            int n3;
            int n4 = (string = string.trim()).indexOf(59);
            if (n4 >= 0) {
                string = string.substring(0, n4).trim();
            }
            if ((n3 = string.indexOf(58)) >= 0 && Util.isLabelDef(string.subSequence(0, n3 + 1))) {
                object2 = string.substring(0, n3);
                string = string.substring(n3 + 1).trim();
                object = new Label();
                ((Label)object).codeLine = n2;
                ((Label)object).fileLine = n;
                ((Label)object).name = object2;
                module.labels.add((Label)object);
            }
            string = Util.clean(string);
            object2 = new ArrayList<CharSequence>();
            Util.splitPipe(string, object2);
            object = object2.iterator();
            while (object.hasNext()) {
                CharSequence charSequence = (CharSequence)object.next();
                String string2 = null;
                String string3 = null;
                String string4 = charSequence.toString();
                ArrayList<DataType> arrayList = new ArrayList<DataType>();
                int n5 = string4.indexOf(32);
                if (n5 >= 0 && Util.isLabel(string4.subSequence(0, n5))) {
                    string2 = string4.substring(0, n5);
                    if (!(string4 = string4.substring(n5 + 1).trim()).isEmpty()) {
                        string3 = string4;
                    }
                    Util.parseArgs(string3, arrayList);
                } else {
                    string2 = string4;
                }
                for (DataType dataType : arrayList) {
                    dataType.finalize();
                }
                Instruction instruction = new Instruction();
                instruction.fileLine = n;
                instruction.codeLine = n2++;
                instruction.instruction = string2;
                instruction.args = arrayList;
                module.instructions.add(instruction);
            }
            ++n;
        }
        this.resolveNumericLabels(module);
        this.populateLabelMap(module);
    }

    public Module parseFile(File file) {
        try {
            Module module = new Module();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            this.parseBuffer(bufferedReader, module);
            bufferedReader.close();
            module.fileName = file.getPath();
            return module;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public List<Instruction> parseLine(String string) {
        ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
        string = string.trim();
        string = Util.clean(string);
        ArrayList<CharSequence> arrayList2 = new ArrayList<CharSequence>();
        Util.splitPipe(string, arrayList2);
        for (CharSequence charSequence : arrayList2) {
            String string2 = null;
            String string3 = null;
            String string4 = charSequence.toString();
            ArrayList<DataType> arrayList3 = new ArrayList<DataType>();
            int n = string4.indexOf(32);
            if (n >= 0 && Util.isLabel(string4.subSequence(0, n))) {
                string2 = string4.substring(0, n);
                if (!(string4 = string4.substring(n + 1).trim()).isEmpty()) {
                    string3 = string4;
                }
                Util.parseArgs(string3, arrayList3);
            } else {
                string2 = string4;
            }
            for (DataType dataType : arrayList3) {
                dataType.finalize();
            }
            Instruction instruction = new Instruction();
            instruction.fileLine = 0;
            instruction.codeLine = 0;
            instruction.instruction = string2;
            instruction.args = arrayList3;
            arrayList.add(instruction);
        }
        return arrayList;
    }

    public Module parseString(String string) {
        try {
            Module module = new Module();
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            this.parseBuffer(bufferedReader, module);
            bufferedReader.close();
            return module;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private void populateLabelMap(Module module) {
        module.labelMap = new Dictionary();
        for (Label label : module.labels) {
            module.labelMap.put(label.name, label);
        }
    }

    private void resolveNumericLabels(Module module) {
        Object object;
        int n;
        for (Label object2 : module.labels) {
            if (!Util.isPrivateNumericLabelDef(object2.name + ":")) continue;
            n = 1;
            object = ".L" + object2.name + "C-B" + n;
            while (this.hasValue((String)object, module.labels)) {
                object = ".L" + object2.name + "C-B" + ++n;
            }
            object2.name = object;
        }
        for (Instruction instruction : module.instructions) {
            for (n = 0; n < instruction.args.size(); ++n) {
                object = instruction.args.get(n);
                if (!((DataType)object).isSymbol()) continue;
                SymbolType symbolType = (SymbolType)object;
                if (!Util.isPrivateNumericLabel(symbolType.value)) continue;
                String string = symbolType.value;
                String string2 = string.substring(0, string.length() - 1);
                char c = string.charAt(string.length() - 1);
                int n2 = instruction.codeLine;
                Label label = null;
                int n3 = Integer.MAX_VALUE;
                for (Label label2 : module.labels) {
                    int n4 = 0;
                    if (c == 'f') {
                        n4 = label2.codeLine - n2;
                    } else if (c == 'b') {
                        n4 = n2 - label2.codeLine;
                    } else {
                        throw new RuntimeException();
                    }
                    if (n4 <= 0 || !label2.name.startsWith(".L" + String.valueOf(string2) + "C-B") || n4 > n3) continue;
                    n3 = n4;
                    label = label2;
                }
                instruction.args.set(n, SymbolType.getInstance(label.name));
            }
        }
    }
}

