/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.sasm.struct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ArrayView<T> {
    private final List<T> list;
    private final int begin;
    private final int end;

    public ArrayView() {
        this.list = null;
        this.begin = 0;
        this.end = 0;
    }

    public ArrayView(List<T> list) {
        this.list = list;
        this.begin = 0;
        this.end = list.size();
    }

    private ArrayView(List<T> list, int n, int n2) {
        this.list = list;
        this.begin = n;
        this.end = n2;
    }

    public ArrayView(T[] TArray) {
        this.list = new ArrayList<T>(TArray.length);
        this.begin = 0;
        this.end = TArray.length;
        for (int i = 0; i < TArray.length; ++i) {
            this.list.add(TArray[i]);
        }
    }

    private ArrayView<T> __copy() {
        if (this.isEmpty()) {
            return new ArrayView<T>();
        }
        ArrayList<T> arrayList = new ArrayList<T>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            arrayList.add(this.get(i));
        }
        return new ArrayView(arrayList, 0, this.size());
    }

    public List<T> __list() {
        return this.list;
    }

    public ArrayView<T> add(T t) {
        List<T> list = this.getInstance(1);
        if (this.end == list.size()) {
            list.add(t);
            return new ArrayView<T>(list, this.begin, this.end + 1);
        }
        return this.__copy().add(t);
    }

    public ArrayView<T> addAll(Collection<? extends T> collection) {
        List<T> list = this.getInstance(collection.size());
        if (this.end == list.size()) {
            list.addAll(collection);
            return new ArrayView<T>(list, this.begin, this.end + collection.size());
        }
        return this.__copy().addAll(collection);
    }

    public T get(int n) {
        assert (n >= 0);
        return this.list.get(this.begin + n);
    }

    public T getFirst() {
        return this.get(0);
    }

    private List<T> getInstance(int n) {
        List<T> list = this.list;
        if (list == null) {
            list = new ArrayList<T>(n);
        }
        return list;
    }

    public T getLast() {
        return this.get(this.size() - 1);
    }

    public boolean isEmpty() {
        return this.begin == this.end;
    }

    public ArrayView<T> set(int n, T t) {
        T t2 = this.get(n);
        if (t2 == t || t2.equals(t)) {
            return this;
        }
        ArrayList<T> arrayList = new ArrayList<T>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            if (i == n) {
                arrayList.add(t);
                continue;
            }
            arrayList.add(this.get(i));
        }
        return new ArrayView(arrayList, 0, this.size());
    }

    public int size() {
        return this.end - this.begin;
    }

    public ArrayView<T> subList(int n, int n2) {
        assert (n >= 0);
        assert (n2 >= 0);
        assert (n <= n2);
        if (n == n2) {
            return new ArrayView<T>();
        }
        int n3 = this.begin + n;
        int n4 = this.begin + n2;
        assert (this.begin <= n3 && n4 <= this.end);
        if (n3 == this.begin && n4 == this.end) {
            return this;
        }
        assert (this.list != null);
        return new ArrayView<T>(this.list, n3, n4);
    }

    public String toString() {
        if (this.list == null) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Integer.toHexString(this.list.hashCode()));
        stringBuilder.append("[");
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.list.get(this.begin + i).toString());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

