/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.sasm.struct;

import java.util.List;

public class StringView
implements CharSequence,
Comparable<CharSequence> {
    private final String str;
    private final int begin;
    private final int end;

    public static void split(String string, char c, List<CharSequence> list) {
        int n = 0;
        int n2 = 0;
        while (true) {
            if ((n2 = string.indexOf(c, n = ++n2)) == -1) {
                list.add(new StringView(string, n, string.length()));
                return;
            }
            list.add(new StringView(string, n, n2));
        }
    }

    public StringView(String string) {
        this.str = string;
        this.begin = 0;
        this.end = string.length();
        assert (this.str == string);
    }

    private StringView(String string, int n, int n2) {
        this.str = string;
        this.begin = n;
        this.end = n2;
        assert (this.str == string);
    }

    @Override
    public char charAt(int n) {
        assert (n >= 0);
        assert (this.begin + n < this.end);
        return this.str.charAt(this.begin + n);
    }

    @Override
    public int compareTo(CharSequence charSequence) {
        int n = Math.min(this.length(), charSequence.length());
        for (int i = 0; i < n; ++i) {
            if (this.charAt(i) == charSequence.charAt(i)) continue;
            return this.charAt(i) - charSequence.charAt(i);
        }
        if (this.length() != charSequence.length()) {
            return this.length() - charSequence.length();
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (this.length() != string.length()) {
                return false;
            }
            return this.compareTo(string) == 0;
        }
        if (object instanceof StringView) {
            StringView stringView = (StringView)object;
            if (this.str == stringView.str && this.begin == stringView.begin && this.end == stringView.end) {
                return true;
            }
            return this.compareTo(stringView) == 0;
        }
        return this.equals(object);
    }

    public int hashCode() {
        int n = 0;
        int n2 = this.length();
        for (int i = 0; i < n2; ++i) {
            n += this.charAt(i) * this.pow(31, n2 - 1 - i);
        }
        return n;
    }

    public int indexOf(char c) {
        for (int i = 0; i < this.length(); ++i) {
            if (this.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(char c, int n) {
        for (int i = n; i < this.length(); ++i) {
            if (this.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.begin == this.end;
    }

    @Override
    public int length() {
        return this.end - this.begin;
    }

    private int pow(int n, int n2) {
        int n3 = 1;
        for (int i = 0; i < n2; ++i) {
            n3 *= n;
        }
        return n3;
    }

    public StringView[] split(char c) {
        int n = 0;
        for (int i = 0; i < this.length(); ++i) {
            if (this.charAt(i) != c) continue;
            ++n;
        }
        StringView[] stringViewArray = new StringView[n + 1];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if ((n4 = this.indexOf(c, n3 = ++n4)) == -1) break;
            stringViewArray[n2] = new StringView(this.str, this.begin + n3, this.begin + n4);
            ++n2;
        }
        stringViewArray[n2] = new StringView(this.str, this.begin + n3, this.end);
        return stringViewArray;
    }

    public boolean startsWith(String string) {
        if (string.length() > this.length()) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (this.charAt(i) == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.substring(n, n2);
    }

    public StringView substring(int n) {
        int n2 = this.begin + n;
        int n3 = this.end;
        if (n2 == this.begin && n3 == this.end) {
            return this;
        }
        return new StringView(this.str, n2, n3);
    }

    public StringView substring(int n, int n2) {
        int n3 = this.begin + n;
        int n4 = this.begin + n2;
        if (n3 == this.begin && n4 == this.end) {
            return this;
        }
        return new StringView(this.str, n3, n4);
    }

    @Override
    public String toString() {
        if (this.begin == 0 && this.end == this.str.length()) {
            return this.str;
        }
        return this.str.substring(this.begin, this.end);
    }

    public StringView trim() {
        int n;
        int n2 = this.length();
        for (n = 0; n < n2 && (this.charAt(n) == ' ' || this.charAt(n) == '\t' || this.charAt(n) == '\n'); ++n) {
        }
        while (n < n2 && (this.charAt(n2 - 1) == ' ' || this.charAt(n2 - 1) == '\t' || this.charAt(n2 - 1) == '\n')) {
            --n2;
        }
        if (this.begin + n == this.begin && this.begin + n2 == this.end) {
            return this;
        }
        return new StringView(this.str, this.begin + n, this.begin + n2);
    }
}

