/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.sasm.type;

import de.slashbinbash.sasm.type.DataType;
import de.slashbinbash.sasm.type.DataTypeEnum;

public class BooleanType
extends DataType {
    public static final BooleanType TRUE = new BooleanType(true);
    public static final BooleanType FALSE = new BooleanType(false);
    public final boolean value;

    public static BooleanType getInstance(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    private BooleanType(boolean bl) {
        super(DataTypeEnum.BOOLEAN);
        this.value = bl;
    }

    @Override
    public int compareTo(DataType dataType) {
        if (dataType.isWildcard()) {
            return 0;
        }
        if (!this.isSame(dataType)) {
            return -1;
        }
        BooleanType booleanType = (BooleanType)dataType;
        if (this.value == booleanType.value) {
            return 0;
        }
        if (this.value && !booleanType.value) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

