/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.sasm.type;

import de.slashbinbash.sasm.type.DataTypeEnum;

public abstract class DataType
implements Comparable<DataType> {
    public static final int CACHE_SIZE = 25;
    public final DataTypeEnum type;
    protected boolean constant = false;

    public DataType(DataTypeEnum dataTypeEnum) {
        this.type = dataTypeEnum;
    }

    public void finalize() {
        this.constant = true;
    }

    @Override
    public abstract int compareTo(DataType var1);

    public boolean equals(Object object) {
        DataType dataType;
        return object instanceof DataType && this.compareTo(dataType = (DataType)object) == 0;
    }

    public boolean isBlock() {
        return this.type == DataTypeEnum.BLOCK;
    }

    public boolean isBoolean() {
        return this.type == DataTypeEnum.BOOLEAN;
    }

    public boolean isInteger() {
        return this.type == DataTypeEnum.INTEGER;
    }

    public boolean isLabel() {
        return this.type == DataTypeEnum.LABEL;
    }

    public boolean isList() {
        return this.type == DataTypeEnum.LIST;
    }

    public boolean isName() {
        return this.type == DataTypeEnum.NAME;
    }

    public boolean isObject() {
        return this.type == DataTypeEnum.OBJECT;
    }

    public boolean isSame(DataType dataType) {
        return this.type == dataType.type;
    }

    public boolean isStack() {
        return this.type == DataTypeEnum.STACK;
    }

    public boolean isString() {
        return this.type == DataTypeEnum.STRING;
    }

    public boolean isSymbol() {
        return this.type == DataTypeEnum.SYMBOL;
    }

    public boolean isWildcard() {
        return this.type == DataTypeEnum.WILDCARD;
    }
}

