/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.sasm.type;

import de.slashbinbash.sasm.type.DataType;
import de.slashbinbash.sasm.type.DataTypeEnum;
import java.util.ArrayList;
import java.util.List;

public class ListType
extends DataType {
    public static final ListType EMPTY = new ListType(new DataType[0]);
    private final List<DataType> value;

    private List<DataType> value() {
        assert (!this.constant);
        return this.value;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public ListType() {
        super(DataTypeEnum.LIST);
        this.value = new ArrayList<DataType>();
    }

    public ListType(ListType listType) {
        super(DataTypeEnum.LIST);
        this.value = new ArrayList<DataType>(listType.value);
    }

    public ListType(List<DataType> list) {
        super(DataTypeEnum.LIST);
        this.value = list;
    }

    public ListType(DataType[] dataTypeArray) {
        super(DataTypeEnum.LIST);
        this.value = new ArrayList<DataType>(dataTypeArray.length);
        for (int i = 0; i < dataTypeArray.length; ++i) {
            this.value.add(dataTypeArray[i]);
        }
    }

    public void add(DataType dataType) {
        assert (!this.constant);
        this.value.add(dataType);
    }

    public DataType getLast() {
        return this.value.getLast();
    }

    public int indexOf(DataType dataType) {
        return this.value.indexOf(dataType);
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public List<DataType> subList(int n, int n2) {
        return this.value.subList(n, n2);
    }

    @Override
    public int compareTo(DataType dataType) {
        List<DataType> list = this.value;
        List<DataType> list2 = ((ListType)dataType).value;
        if (list.size() != list2.size()) {
            return list.size() - list2.size();
        }
        for (int i = 0; i < list.size(); ++i) {
            DataType dataType2;
            DataType dataType3 = list.get(i);
            int n = dataType3.compareTo(dataType2 = list2.get(i));
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    public DataType get(int n) {
        return this.value.get(n);
    }

    public void set(int n, DataType dataType) {
        assert (!this.constant);
        this.value.set(n, dataType);
    }

    public String toString() {
        return this.value.toString();
    }

    public int size() {
        return this.value.size();
    }
}

