/*
 * Decompiled with CFR 0.152.
 */
package de.slashbinbash.sasm.type;

import de.slashbinbash.sasm.type.DataType;
import de.slashbinbash.sasm.type.DataTypeEnum;

public class StringType
extends DataType {
    public static final int SIZE = 25;
    private static final StringType[] cache = new StringType[25];
    public final String value;

    public static StringType getInstance(CharSequence charSequence) {
        int n = Math.abs(charSequence.hashCode()) % 25;
        if (cache[n] == null || !charSequence.equals(StringType.cache[n].value)) {
            StringType.cache[n] = new StringType(charSequence.toString());
        }
        return cache[n];
    }

    private StringType(String string) {
        super(DataTypeEnum.STRING);
        this.value = string;
    }

    @Override
    public int compareTo(DataType dataType) {
        if (dataType.isWildcard()) {
            return 0;
        }
        if (!this.isSame(dataType)) {
            return -1;
        }
        StringType stringType = (StringType)dataType;
        return this.value.compareTo(stringType.value);
    }

    public String toString() {
        return this.value;
    }
}

